package ru.yandex.partner.jsonapi.models.block.rtb.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.CoreConstants;
import ru.yandex.partner.core.entity.QueryOpts;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.service.UserService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.models.block.BlockDesignTemplateTypesDefaultsService;

@Service
public class InternalRtbBlockDesignTemplateTypesDefaultsService
        extends BlockDesignTemplateTypesDefaultsService<InternalRtbBlock> {

    private final UserService userService;

    @Autowired
    public InternalRtbBlockDesignTemplateTypesDefaultsService(
            UserService userService
    ) {
        super();
        this.userService = userService;
    }

    @Override
    protected String getSiteVersion(InternalRtbBlock block) {
        return block.getSiteVersion();
    }

    @Override
    protected Boolean getShowVideo(InternalRtbBlock block) {
        return block.getShowVideo();
    }

    @Override
    protected User getOwner(InternalRtbBlock block) {
        return userService.findAll(QueryOpts.forClass(User.class)
                .withProps(User.FEATURES)
                .withFilter(CoreFilterNode.eq(
                        UserFilters.CLIENT_ID,
                        CoreConstants.ADINSIDE_CLIENT_ID)
                )
        ).get(0);
    }
}
