package ru.yandex.partner.jsonapi.models.block.rtb.mobile;

import java.util.List;

import ru.yandex.partner.core.entity.block.model.BlockWithMobileAppMode;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__MOBILE_APP_MODE;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.VIEW_FIELD__MOBILE_APP_MODE;

public class ApiMobileAppModeModelPart<B extends BlockWithMobileAppMode> implements
        ApiModelPart<B>, GodModeAvailable<B> {

    private final String resourceType;
    private final GodModeAvailable<B> godModeAvailableDelegate;

    public ApiMobileAppModeModelPart(String resourceType, GodModeAvailable<B> godModeAvailableDelegate) {
        this.resourceType = resourceType;
        this.godModeAvailableDelegate = godModeAvailableDelegate;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, Integer>convertibleApiField(Integer.class, B.MOBILE_APP_MODE)
                        .withEditableFunction(checkableAnd(List.of(
                                ApiFieldsAccessRulesFunction
                                        .byRight(EDIT_FIELD__MOBILE_APP_MODE.getFullRightName(resourceType)),
                                isGodModeEditableFunction()
                        )))
                        .withAddFieldLikeEditableFunction()
                        .withAvailableFunction(checkableByRight(
                                VIEW_FIELD__MOBILE_APP_MODE.getFullRightName(resourceType))
                        )
                        .build(BlockCrnkJsonFieldAliases.MOBILE_APP_MODE));
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return godModeAvailableDelegate.isGodModeFunction();
    }
}
