package ru.yandex.partner.jsonapi.models.block.rtb.mobile;

import java.util.List;
import java.util.function.BiConsumer;

import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.model.BlockWithMobileRewardAndBlockType;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.neverPermit;


public class ApiMobileRewardModelPart<B extends BlockWithMobileRewardAndBlockType> implements ApiModelPart<B> {

    private final String resourceType;

    public ApiMobileRewardModelPart(String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.<B, Integer>convertibleApiField(Integer.class, B.CURRENCY_VALUE)
                        .withAddFieldFunction(getAddFieldsFunction())
                        .withEditableFunction(getAddFieldsFunction())
                        .withAvailableFunction(getAvailableFunction())
                        .build(BlockCrnkJsonFieldAliases.CURRENCY_VALUE),
                ApiField.<B, String>convertibleApiField(String.class, B.CURRENCY_TYPE)
                        .withAddFieldFunction(getAddFieldsFunction())
                        .withEditableFunction(getAddFieldsFunction())
                        .withAvailableFunction(getAvailableFunction())
                        .build(BlockCrnkJsonFieldAliases.CURRENCY_TYPE),
                ApiField.<B, String>convertibleApiField(String.class, B.CALLBACK)
                        .withAddFieldFunction(neverPermit())
                        .withAvailableFunction(neverPermit())
                        .build(BlockCrnkJsonFieldAliases.CALLBACK),
                ApiField.<B, String>convertibleApiField(String.class, B.SIGN)
                        .withAddFieldFunction(neverPermit())
                        .withAvailableFunction(neverPermit())
                        .build(BlockCrnkJsonFieldAliases.SIGN));
    }

    private BiConsumer<String, ApiFieldsAccessRules.Builder<B>> getAvailableFunction() {
        return checkable(
                new ApiFieldsAccessRulesFunction<>(
                        (userAuthentication, block) -> {
                            String blockType = block.getBlockType();
                            return blockType == null || MobileBlockType.REWARDED.hasType(block);
                        }, MobileRtbBlock.BLOCK_TYPE)
                );
    }

    private BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> getAddFieldsFunction() {
        return checkable(
                new ApiFieldsAccessRulesFunction<>(
                        (userAuthentication, block) -> {
                            String blockType = block.getPatchedOrElseActual().getBlockType();
                            return blockType == null || MobileBlockType.REWARDED.getLiteral().equals(blockType);
                        }, MobileRtbBlock.BLOCK_TYPE)
        );
    }

}
