package ru.yandex.partner.jsonapi.models.block.rtb.mobile;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndRichMedia;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.access.NotCustomBkDataAccessRuleFunction;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

import static ru.yandex.partner.core.block.MobileBlockType.NATIVE;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__RICH_MEDIA;


public class ApiMobileRichMediaModelPart<B extends BlockWithBlockTypeAndRichMedia &
        BlockWithCustomBkDataFlagIsCustomBkDataPropHolder> implements ApiModelPart<B>, GodModeAvailable<B> {

    private final String resourceType;

    public ApiMobileRichMediaModelPart(String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.<B, Boolean>convertibleApiField(Boolean.class, B.RICH_MEDIA)
                        .withAddFieldFunction(getAddFieldFunction())
                        .withDefaultsFunction(getDefaultsFunction())
                        .withEditableFunction(getEditableFunction())
                        .withAvailableFunction(getAvailableFunction())
                        .build(BlockCrnkJsonFieldAliases.RICH_MEDIA));
    }

    private BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> getAddFieldFunction() {
        return checkable(new ApiFieldsAccessRulesFunction<>(
                (ua, editableData) -> isRichMediaAccessible(editableData.getPatchedOrElseActual(), ua),
                List.of(B.BLOCK_TYPE)
        ));
    }

    private BiConsumer<String, ApiFieldsAccessRules.Builder<B>> getAvailableFunction() {
        return checkable(new ApiFieldsAccessRulesFunction<>(
                (ua, block) -> isRichMediaAccessible(block, ua),
                List.of(B.BLOCK_TYPE)
        ));
    }


    private BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> getEditableFunction() {
        return checkableAnd(List.of(
                new ApiFieldsAccessRulesFunction<>(
                        (ua, editableData) -> isRichMediaAccessible(editableData.getPatchedOrElseActual(), ua),
                        List.of(B.BLOCK_TYPE)),
                isGodModeEditableFunction()
        ));
    }

    /**
     * Проверяем одно и то же условие для вычисления available, editable и add field.
     * Метод создан, чтобы избежать дублирование кода, а постфикс accessible не несет _особой_ смысловой нагрузки,
     * в отличие от available, editable и add функций
     */
    private boolean isRichMediaAccessible(B block, UserAuthentication ua) {
        return NATIVE.hasType(block) && ua.userHasRight(EDIT_FIELD__RICH_MEDIA.getFullRightName(resourceType));
    }


    private Function<QueryParamsContext<B>, Map<String, Object>> getDefaultsFunction() {
        return context -> {
            B block = context.getModelFromAttributes();
            var userAuthentication = context.getUserAuthentication();
            if (NATIVE.hasType(block) &&
                    userAuthentication.userHasRight(EDIT_FIELD__RICH_MEDIA.getFullRightName(resourceType))) {
                return Map.of(BlockCrnkJsonFieldAliases.RICH_MEDIA, List.of(0, 1),
                        BlockCrnkJsonFieldAliases.DEFAULT_VALUES, Map.of(
                                BlockCrnkJsonFieldAliases.RICH_MEDIA, 0));
            }
            return Map.of();
        };

    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return new NotCustomBkDataAccessRuleFunction<B>();
    }
}
