package ru.yandex.partner.jsonapi.models.block.rtb.mobile;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonShowVideo;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCommonShowVideoWithDelegateModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;
import ru.yandex.partner.jsonapi.models.block.parts.ShowVideoAvailable;

public class ApiMobileRtbShowVideoModelPart<B extends BlockWithCommonShowVideo>
        extends ApiCommonShowVideoWithDelegateModelPart<B> implements ShowVideoAvailable<B> {

    private final ShowVideoAvailable<B> showVideoAvailableDelegate;
    private final String modelName;

    public ApiMobileRtbShowVideoModelPart(String modelName,
                                          ShowVideoAvailable<B> showVideoAvailableDelegate,
                                          GodModeAvailable<B> godModeAvailableDelegate) {
        super(modelName, showVideoAvailableDelegate, godModeAvailableDelegate);
        this.showVideoAvailableDelegate = showVideoAvailableDelegate;
        this.modelName = modelName;
    }

    /**
     * В перле есть возможность докидывать права по фиче https://a.yandex-team.ru/arcadia/partner/perl/partner2/lib/Application/Model/Users/Features.pm?rev=e96f6f2c9e4d9f007963f1f023ee4faff4d2d11f#L94
     * В джаве пока такого нет, поэтому нам подходит либо фича, либо право
     *
     * UPD: заменил на alwaysAllow, т.к. в java фича у всех
     * @return
     */
    @Override
    protected ApiFieldsAccessRulesFunction<EditableData<B>> getEditableRightAccessFunction() {
        return ApiFieldsAccessRulesFunction.alwaysAllow();
    }

    /**
     * решил не проверять фичу, тк она в любом случае будет выпиливаться и
     * к тому же проверка требует доп запроса в базу, в отличие от проверки
     * в editable_fields, т.к там сначала собираются все требуемые поля.
     * В случае add_fields сущность приходит к нам в параметре attributes и может
     * быть неполная
     */
    @Override
    protected ApiFieldsAccessRulesFunction<EditableData<B>> getAddfieldRightAccessFunction() {
        return ApiFieldsAccessRulesFunction.alwaysAllow();
    }

    @Override
    protected Function<QueryParamsContext<B>, Map<String, Object>> getShowVideoDefaultsFunction() {
        return context -> {
            B block = context.getModelFromAttributes();

            var userAuthentication = context.getUserAuthentication();
            List<Integer> result = new ArrayList<>(2);
            if (showVideoAvailableDelegate.isShowVideoApplicable(modelName, userAuthentication, block)) {
                result.add(0);
                result.add(1);
            } else {
                result.add(getDefaultShowVideoValue(block) ? 1 : 0);
            }
            return Map.of(BlockCrnkJsonFieldAliases.SHOW_VIDEO, result,
                    BlockCrnkJsonFieldAliases.DEFAULT_VALUES, Map.of(
                            BlockCrnkJsonFieldAliases.SHOW_VIDEO,
                            showVideoAvailableDelegate.getDefaultShowVideoValue(block) ? 1 : 0));
        };
    }


}
