package ru.yandex.partner.jsonapi.models.block.rtb.mobile;

import java.util.Map;
import java.util.function.Function;

import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;

import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowVideo;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowVideoAndStrategy;
import ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype.ShowVideoApplicableService;
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService;
import ru.yandex.partner.core.utils.CollectionUtils;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.block.filter.provider.MobileStrategyDictionaryValueProvider;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.fields.QueryParamsContext;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.parts.ApiStrategyWithDelegateModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;
import ru.yandex.partner.jsonapi.models.block.parts.ShowVideoAvailable;
import ru.yandex.partner.jsonapi.validation.CovariantPathNodeConverterProvider;

public class ApiMobileRtbStrategyModelPart<B extends BlockWithBlockTypeAndShowVideoAndStrategy>
        extends ApiStrategyWithDelegateModelPart<B> {

    private final StrategyDefaultsFieldsService strategyDefaultsFieldsService;
    private final ShowVideoApplicableService<BlockWithBlockTypeAndShowVideo> showVideoApplicableService;
    private final MessageSourceAccessor translations;

    public ApiMobileRtbStrategyModelPart(
            String modelName,
            ShowVideoAvailable<B> showVideoAvailableDelegate,
            GodModeAvailable<B> godModeAvailableDelegate,
            StrategyDefaultsFieldsService strategyDefaultsFieldsService,
            ShowVideoApplicableService<BlockWithBlockTypeAndShowVideo> showVideoApplicableService,
            MessageSource messageSource) {
        super(modelName, showVideoAvailableDelegate, godModeAvailableDelegate,
                new MobileStrategyDictionaryValueProvider());
        this.showVideoApplicableService = showVideoApplicableService;
        this.strategyDefaultsFieldsService = strategyDefaultsFieldsService;
        this.translations = new MessageSourceAccessor(messageSource);
    }

    @Override
    protected Function<QueryParamsContext<B>, Map<String, Object>> getDefaultsFunction() {
        return context -> {
            if (converterProvider == null) {
                var builder = new CovariantPathNodeConverterProvider.Builder();
                this.configurePathNodeConverter(builder);
                converterProvider = builder.build();
            }
            B block = context.getModelFromAttributes();
            return getDictionaryValues().entrySet().stream()
                    .map(entry -> {
                        Long strategyId = entry.getKey();
                        return Map.of(
                                "id", strategyId.toString(),
                                "name", translations.getMessage(entry.getValue()),
                                "fields", strategyDefaultsFieldsService.getFields(
                                        strategyId,
                                        showVideoApplicableService.isShowVideoApplicable(
                                                block,
                                                context.getUserAuthentication()
                                                        .userHasRight(BlockRightNames.EDIT_FIELD__RICH_MEDIA
                                                                .getFullRightName(getModelName()))),
                                        block.getShowVideo()
                                )
                        );
                    })
                    .collect(CollectionUtils.keyToList(BlockCrnkJsonFieldAliases.STRATEGY));
        };
    }

    @Override
    protected ApiFieldsAccessRulesFunction<B> videoActiveAvailableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, rtbBlock) -> false);
    }

    @Override
    protected ApiFieldsAccessRulesFunction<EditableData<B>> hasVideoFieldsFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, rtbBlock) -> false);
    }

    @Override
    protected boolean separateCpmSupported() {
        return false;
    }

    @Override
    protected ApiFieldsAccessRulesFunction<EditableData<B>> strategyEditableFunction() {
        return ApiFieldsAccessRulesFunction.alwaysAllow();
    }
}
