package ru.yandex.partner.jsonapi.models.block.rtb.mobile;

import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;

import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowSlider;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockTypeAndShowSliderAndIsCustomFormatDirect;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;

import static ru.yandex.partner.core.block.MobileBlockType.INTERSTITIAL;
import static ru.yandex.partner.core.block.MobileBlockType.REWARDED;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.alwaysPermit;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__IS_CUSTOM_FORMAT_DIRECT;

public class ApiShowSliderModelPart<B extends BlockWithBlockTypeAndShowSliderAndIsCustomFormatDirect>
        extends AbstractApiModelPart<B> implements GodModeAvailable<B> {

    private static final Set<String> READ_ONLY_BLOCK_TYPES = MobileBlockType.literals(
            INTERSTITIAL, REWARDED
    );

    private final GodModeAvailable<B> delegateGodModeAvailable;

    public ApiShowSliderModelPart(String modelName, GodModeAvailable<B> godModeAvailable) {
        super(modelName);
        this.delegateGodModeAvailable = godModeAvailable;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField
                        .<B, Boolean>convertibleApiField(Boolean.class, BlockWithBlockTypeAndShowSlider.SHOW_SLIDER)
                        .withEditableFunction(getShowSliderEditableFieldsFunction())
                        .withAddFieldFunction(getShowSliderAddFieldsFunction())
                        .withAvailableFunction(getShowSliderAvailableFunction())
                        .build(BlockCrnkJsonFieldAliases.SHOW_SLIDER),
                ApiField
                        .<B, Integer>convertibleApiField(Integer.class, BlockWithBlockTypeAndShowSlider.LIMIT)
                        .withEditableFunction(checkableAnd(List.of(
                                getLimitEditableFunction(),
                                isGodModeEditableFunction()
                        )))
                        .withAddFieldFunction(checkable(new ApiFieldsAccessRulesFunction<>(
                                (ua, editableData) -> {
                                    // B block = editableData.getPatchedOrElseActual();
                                    // return !READ_ONLY_BLOCK_TYPES.contains(block.getBlockType());
                                    // выпилить костыль после https://st.yandex-team.ru/PI-29210
                                    return true;
                                },
                                List.of(MobileRtbBlock.BLOCK_TYPE))))
                        .withAvailableFunction(alwaysPermit())
                        .build(BlockCrnkJsonFieldAliases.LIMIT)
        );
    }

    private ApiFieldsAccessRulesFunction<EditableData<B>> getLimitEditableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (ua, editableData) -> {
                    B block = editableData.getPatchedOrElseActual();
                    return !READ_ONLY_BLOCK_TYPES.contains(block.getBlockType()) &&
                            (!Boolean.TRUE.equals(block.getIsCustomFormatDirect()) ||
                            ua.userHasRight(EDIT_FIELD__IS_CUSTOM_FORMAT_DIRECT.getFullRightName(getModelName())));
        }, List.of(MobileRtbBlock.IS_CUSTOM_FORMAT_DIRECT, MobileRtbBlock.BLOCK_TYPE));
    }

    private BiConsumer<String, ApiFieldsAccessRules.Builder<B>> getShowSliderAvailableFunction() {
        return checkable(
                new ApiFieldsAccessRulesFunction<>(
                        (userAuthentication, block) ->
                                MobileBlockType.NATIVE.hasType(block), BlockWithBlockTypeAndShowSlider.BLOCK_TYPE)
        );
    }

    private BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> getShowSliderAddFieldsFunction() {
        return checkable(
                new ApiFieldsAccessRulesFunction<>(
                        (userAuthentication, editableData) ->
                                MobileBlockType.NATIVE.hasType(editableData.getPatchedOrElseActual()),
                        BlockWithBlockTypeAndShowSlider.BLOCK_TYPE)
        );
    }

    private BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> getShowSliderEditableFieldsFunction() {
        return checkableAnd(List.of(
                new ApiFieldsAccessRulesFunction<>(
                        (userAuthentication, editableData) ->
                                MobileBlockType.NATIVE.hasType(editableData.getPatchedOrElseActual()),
                        BlockWithBlockTypeAndShowSlider.BLOCK_TYPE),
                isGodModeEditableFunction()
        ));
    }


    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return delegateGodModeAvailable.isGodModeFunction();
    }
}
