package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import org.springframework.context.MessageSource;

import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype.MobileShowVideoApplicableService;
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;
import ru.yandex.partner.jsonapi.models.block.parts.ShowVideoAvailable;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.ApiMobileRtbStrategyModelPart;

public class ApiExternalMobileRtbStrategyModelPart
        extends ApiMobileRtbStrategyModelPart<MobileRtbBlock> {


    public ApiExternalMobileRtbStrategyModelPart(String modelName,
                                                 ShowVideoAvailable<MobileRtbBlock> showVideoAvailableDelegate,
                                                 GodModeAvailable<MobileRtbBlock> godModeAvailableDelegate,
                                                 StrategyDefaultsFieldsService strategyDefaultsFieldsService,
                                                 MobileShowVideoApplicableService showVideoApplicableService,
                                                 MessageSource messageSource) {
        super(modelName, showVideoAvailableDelegate, godModeAvailableDelegate,
                strategyDefaultsFieldsService, showVideoApplicableService, messageSource);
    }


    @Override
    protected ApiFieldsAccessRulesFunction<EditableData<MobileRtbBlock>> strategyEditableFunction() {
        return new ApiFieldsAccessRulesFunction<>(
                (userAuthentication, bEditableModelData) -> !Boolean.TRUE.equals(bEditableModelData
                                .getPatchedOrElseActual().getIsBidding()),
                MobileRtbBlock.IS_BIDDING);
    }
}
