package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.block.model.BlockWithIsBidding;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;
import ru.yandex.partner.jsonapi.utils.function.BatchBiFunction;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.alwaysPermit;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__IS_BIDDING;

public class ApiIsBiddingModelPart<B extends BlockWithIsBidding> implements
        ApiModelPart<B>, GodModeAvailable<B> {

    private final String resourceType;
    private final GodModeAvailable<B> godModeAvailableDelegate;

    public ApiIsBiddingModelPart(String resourceType, GodModeAvailable<B> godModeAvailableDelegate) {
        this.resourceType = resourceType;
        this.godModeAvailableDelegate = godModeAvailableDelegate;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.convertibleApiField(Boolean.class, B.IS_BIDDING,
                                BatchFunction.<B, Boolean>one(b -> Boolean.TRUE.equals(b.getIsBidding())),
                                BatchBiFunction.byModelProperty(B.IS_BIDDING)
                        )
                        .withAvailableFunction(alwaysPermit())
                        .withEditableFunction(checkableAnd(List.of(
                                ApiFieldsAccessRulesFunction
                                        .byRight(EDIT_FIELD__IS_BIDDING.getFullRightName(resourceType)),
                                isGodModeEditableFunction()
                        )))
                        .withAddFieldFunction(
                               alwaysPermit())
                        .withDefaultsFunction(context -> Map.of(
                                BlockCrnkJsonFieldAliases.IS_BIDDING, Boolean.FALSE
                        ))
                        .build(BlockCrnkJsonFieldAliases.IS_BIDDING)
        );
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return godModeAvailableDelegate.isGodModeFunction();
    }
}
