package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BlockWithIsMobileMediation;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.messages.block.RtbMsg;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockFilterNameEnum;
import ru.yandex.partner.jsonapi.models.block.parts.GodModeAvailable;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.alwaysPermit;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction.checkableAnd;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.ADD_FIELD_IS_MOBILE_MEDIATION;
import static ru.yandex.partner.jsonapi.models.block.BlockRightNames.EDIT_FIELD__IS_MOBILE_MEDIATION;

public class ApiIsMobileMediationModelPart<B extends BlockWithIsMobileMediation>
        implements ApiModelPart<B>, GodModeAvailable<B> {

    private final String resourceType;
    private final GodModeAvailable<B> godModeAvailableDelegate;

    public ApiIsMobileMediationModelPart(String resourceType, GodModeAvailable<B> godModeAvailableDelegate) {
        this.resourceType = resourceType;
        this.godModeAvailableDelegate = godModeAvailableDelegate;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.<B, Boolean>convertibleApiField(Boolean.class, B.IS_MOBILE_MEDIATION)
                        .withAvailableFunction(alwaysPermit())
                        .withEditableFunction(checkableAnd(List.of(
                                ApiFieldsAccessRulesFunction
                                        .byRight(EDIT_FIELD__IS_MOBILE_MEDIATION.getFullRightName(resourceType)),
                                isGodModeEditableFunction()
                        )))
                        .withAddFieldFunction(
                                checkableByRight(ADD_FIELD_IS_MOBILE_MEDIATION
                                        .getFullRightName(resourceType))
                        ).withDefaultsFunction(context -> Map.of(
                                BlockCrnkJsonFieldAliases.IS_MOBILE_MEDIATION, Boolean.FALSE
                        ))
                        .build(BlockCrnkJsonFieldAliases.IS_MOBILE_MEDIATION)
        );
    }

    @Override
    public Map<String, CrnkFilter<B, ?>> getFilters() {
        var list = List.<CrnkFilter<B, ?>>of(
                CrnkFilter.builder(BlockFilterNameEnum.IS_MOBILE_MEDIATION)
                        .setLabel(RtbMsg.IS_MOBILE_MEDIATION)
                        .setExposed(() -> false)
                        .toCrnkFilter(BlockFilters.IS_MOBILE_MEDIATION)
        );

        return list.stream()
                .collect(Collectors.toMap(
                        CrnkFilter::getName,
                        baseBlockCrnkFilter -> baseBlockCrnkFilter
                ));
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return godModeAvailableDelegate.isGodModeFunction();
    }
}
