package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.page.service.ReachablePageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.page.MobileStoreType;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.models.block.parts.ApiBaseBlockModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class ApiMobileRtbBaseBlockModelPart extends ApiBaseBlockModelPart<MobileRtbBlock, MobileAppSettings> {

    @SuppressWarnings("checkstyle:parameternumber")
    public ApiMobileRtbBaseBlockModelPart(CrnkFilterParser crnkFilterParser,
                                          CrnkModelFilters<MobileAppSettings> pageCrnkModelFilters,
                                          RequestAuthorizationService requestAuthorizationService,
                                          Policy<MobileAppSettings> pagePolicy, BlockUniqueIdConverter.Prefixes prefix,
                                          ReachablePageService<MobileRtbBlock> reachablePageService,
                                          Supplier<CoreFilterNode<MobileAppSettings>> authPageFilterProvider,
                                          Class<MobileAppSettings> pageClass, boolean needPageIdFilter) {
        super(crnkFilterParser, pageCrnkModelFilters, requestAuthorizationService, pagePolicy, prefix,
                reachablePageService, authPageFilterProvider, pageClass, needPageIdFilter);
    }

    @Override
    protected Function<MobileAppSettings, Map<String, Object>> pageMapper() {
        return page -> {
            MobileStoreType storeType = MobileStoreType.getById(page.getType());
            return Map.of(
                    PageCrnkJsonFieldAliases.CAPTION, page.getCaption(),
                    PageCrnkJsonFieldAliases.DOMAIN, page.getDomain(),
                    PageCrnkJsonFieldAliases.PAGE_ID, page.getId().toString(),
                    PageCrnkJsonFieldAliases.OWNER_ID, page.getOwnerId().toString(),
                    PageCrnkJsonFieldAliases.APP_IS_APPROVED, page.getIsAppApproved() ? "1" : "0",
                    PageCrnkJsonFieldAliases.APPLICATION_ID, page.getApplicationId().toString(),
                    PageCrnkJsonFieldAliases.STORE_ID, page.getStoreId(),
                    PageCrnkJsonFieldAliases.TYPE_NAME, storeType != null ? storeType.getCaption() : null
            );
        };
    }
}
