package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import java.util.function.BiConsumer;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder;
import ru.yandex.partner.core.entity.block.model.prop.MobileRtbBlockIsMobileMediationPropHolder;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.rtb.ApiRtbCommonModelPart;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;

public class ApiMobileRtbCommonModelPart<B extends BlockWithCommonFields
        & BlockWithCustomBkDataFlagIsCustomBkDataPropHolder
        & MobileRtbBlockIsMobileMediationPropHolder>
        extends ApiRtbCommonModelPart<B> {

    public ApiMobileRtbCommonModelPart(String modelName) {
        super(modelName);
    }

    @Override
    protected BiConsumer<String, ApiFieldsAccessRules.Builder<EditableData<B>>> getAddFieldCaptionFunction() {
        return checkable(
                new ApiFieldsAccessRulesFunction<>(
                        (userAuthentication, bEditableData) -> {
                            boolean hasMobileMediation = Boolean.TRUE.equals(
                                    bEditableData.getPatchedOrElseActual().getIsMobileMediation());

                            return !hasMobileMediation || userAuthentication.userHasRight(
                                    BlockRightNames.CAN_EDIT_MOBILE_MEDIATION.getRightName()
                            );
                        })
        );
    }
}
