package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.block.MobileBlockType;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateExpressionParser;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.type.dspshowvideoandblocktype.MobileShowVideoApplicableService;
import ru.yandex.partner.core.entity.block.type.tags.TagService;
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService;
import ru.yandex.partner.core.entity.custombkoptions.CustomBkOptionsTypedRepository;
import ru.yandex.partner.core.entity.dsp.service.DspService;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.entity.page.service.MobileAppSettingsReachablePageService;
import ru.yandex.partner.core.entity.strategy.StrategyDefaultsFieldsService;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.block.authorization.actions.BlockActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.block.rtb.mobile.external.MobileRtbBlockAuthorizationPolicy;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.MultistateCrnkFilterValueParser;
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService;
import ru.yandex.partner.jsonapi.crnk.page.MobileAppCrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.page.MobilePageReachabilityService;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkMapper;
import ru.yandex.partner.jsonapi.crnk.page.authorization.MobileAppSettingsAuthorizationPolicy;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.DependsHolder;
import ru.yandex.partner.jsonapi.models.block.ApiBlockService;
import ru.yandex.partner.jsonapi.models.block.actions.BlockActionService;
import ru.yandex.partner.jsonapi.models.block.parts.ApiAdfoxBlockModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiBrandsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCloseButtonDelayModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCreateDateModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCustomBkDataModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCustomBkOptionsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiDspModeModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiGeoModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiIgnoredCompatFieldsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiMultistateFieldsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiPiCategoriesModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiPlaceIdModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiReadonlyModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.ApiTagsModelPart;
import ru.yandex.partner.jsonapi.models.block.parts.BaseGodModeAvailable;
import ru.yandex.partner.jsonapi.models.block.parts.ShowVideoAvailableByBlockType;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.ApiMobileAppModeModelPart;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.ApiMobileBlockTypeModelPart;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.ApiMobileRewardModelPart;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.ApiMobileRichMediaModelPart;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.ApiMobileRtbShowVideoModelPart;
import ru.yandex.partner.jsonapi.models.block.rtb.mobile.ApiShowSliderModelPart;
import ru.yandex.partner.jsonapi.models.common.ApiActionsModelPart;
import ru.yandex.partner.jsonapi.models.common.ApiFieldsDependsModelPart;
import ru.yandex.partner.jsonapi.models.common.ApiMultistateModelPart;
import ru.yandex.partner.jsonapi.models.page.mobile.external.ApiMobileAppSettingsMetaData;
import ru.yandex.partner.jsonapi.utils.ConfigurationUtils;
import ru.yandex.partner.libs.authorization.policy.base.Policy;
import ru.yandex.partner.libs.i18n.TranslatableError;

@Configuration
public class ApiMobileRtbConfiguration {
    public static final DependsHolder DEPENDS_HOLDER = new DependsHolder(
            Map.of(
                    BlockCrnkJsonFieldAliases.PAGE_ID,
                    List.of(
                            BlockCrnkJsonFieldAliases.DSPS,
                            BlockCrnkJsonFieldAliases.BLOCK_TYPE,
                            BlockCrnkJsonFieldAliases.CURRENT_CURRENCY
                    ),
                    BlockCrnkJsonFieldAliases.SHOW_VIDEO,
                    List.of(BlockCrnkJsonFieldAliases.DSPS),

                    BlockCrnkJsonFieldAliases.BLOCK_TYPE,
                    List.of(
                            BlockCrnkJsonFieldAliases.DSPS,
                            BlockCrnkJsonFieldAliases.DIRECT_BLOCK,
                            BlockCrnkJsonFieldAliases.MEDIA_BLOCK,
                            BlockCrnkJsonFieldAliases.SHOW_VIDEO,
                            BlockCrnkJsonFieldAliases.RICH_MEDIA,
                            BlockCrnkJsonFieldAliases.CLOSE_BUTTON_DELAY
                    ),

                    BlockCrnkJsonFieldAliases.ID,
                    List.of(BlockCrnkJsonFieldAliases.STRATEGY)

            ),
            Map.of(
                    BlockCrnkJsonFieldAliases.DSPS,
                    List.of(BlockCrnkJsonFieldAliases.PAGE_ID,
                            BlockCrnkJsonFieldAliases.BLOCK_TYPE,
                            BlockCrnkJsonFieldAliases.SHOW_VIDEO),

                    BlockCrnkJsonFieldAliases.BLOCK_TYPE,
                    List.of(BlockCrnkJsonFieldAliases.PAGE_ID),

                    BlockCrnkJsonFieldAliases.DIRECT_BLOCK,
                    List.of(BlockCrnkJsonFieldAliases.BLOCK_TYPE),

                    BlockCrnkJsonFieldAliases.STRATEGY,
                    List.of(BlockCrnkJsonFieldAliases.ID,
                            BlockCrnkJsonFieldAliases.BLOCK_TYPE),

                    BlockCrnkJsonFieldAliases.SHOW_VIDEO,
                    List.of(BlockCrnkJsonFieldAliases.BLOCK_TYPE),

                    BlockCrnkJsonFieldAliases.MEDIA_BLOCK,
                    List.of(BlockCrnkJsonFieldAliases.BLOCK_TYPE),

                    BlockCrnkJsonFieldAliases.RICH_MEDIA,
                    List.of(BlockCrnkJsonFieldAliases.BLOCK_TYPE),

                    BlockCrnkJsonFieldAliases.CLOSE_BUTTON_DELAY,
                    List.of(BlockCrnkJsonFieldAliases.BLOCK_TYPE),

                    BlockCrnkJsonFieldAliases.CURRENT_CURRENCY,
                    List.of(BlockCrnkJsonFieldAliases.PAGE_ID)

            )
    );

    @Bean
    @SuppressWarnings("checkstyle:parameternumber")
    public ApiBlockService<MobileRtbBlock> apiMobileBlockService(
            ApiMobileAppSettingsMetaData apiMobileAppSettingsMetaData,
            ActionPerformer actionPerformer,
            DefectPresentationRegistry<TranslatableError> defectPresentationRegistry,
            RequestAuthorizationService requestAuthorizationService,
            BlockActionsAuthorizationService<MobileRtbBlock> blockBlockActionsAuthorizationService,
            ApiFieldsService<MobileRtbBlock> apiFieldsService,
            ApiMobileRtbModel apiMobileRtbModel,
            BlockService blockService,
            BlockAddService<BlockWithMultistate> blockAddService,
            BlockActionService<MobileRtbBlock> blockBlockActionService,
            MobileRtbAuthBlockContainerConfigurer authBlockContainerConfigurer
    ) {

        return new ApiBlockService<>(
                actionPerformer,
                defectPresentationRegistry,
                requestAuthorizationService,
                blockBlockActionsAuthorizationService,
                apiFieldsService,
                apiMobileRtbModel,
                blockService,
                blockAddService,
                blockBlockActionService,
                authBlockContainerConfigurer,
                apiMobileAppSettingsMetaData
        );
    }

    @Bean
    @SuppressWarnings("checkstyle:parameternumber")
    public ApiMobileRtbModel apiMobileRtbModel(
            ApiMobileRtbMetaData apiMobileRtbMetaData,
            MobileRtbBlockAccessFunctionComposite mobileRtbBlockAccessFunctionComposite,
            RequestAuthorizationService requestAuthorizationService,
            BlockActionsAuthorizationService<MobileRtbBlock> blockBlockActionsAuthorizationService,
            EditableFieldsService<BaseBlock> editableFieldsService,
            CrnkFilterParser crnkFilterParser,
            MobileAppSettingsReachablePageService reachablePageService,
            MobilePageReachabilityService pageReachabilityService,
            MobileShowVideoApplicableService showVideoApplicableService,
            @Value("${partner.block.need-page-id-filter}") boolean needPageIdFilter,
            MobileAppCrnkModelFilters mobileAppCrnkModelFilters,
            TagService tagService,
            CustomBkOptionsTypedRepository customBkOptionsTypedRepository,
            MobileRtbBlockAuthorizationPolicy mobileRtbBlockAuthorizationPolicy,
            MobileAppSettingsAuthorizationPolicy mobileAppSettingsAuthorizationPolicy,
            MobileRtbBlockMultistateGraph mobileRtbBlockMultistateGraph,
            MultistateService multistateService,
            ObjectMapper objectMapper,
            ApiModel<MobileAppSettings> pageApiModel,
            StrategyDefaultsFieldsService strategyDefaultsFieldsService,
            DspService dspService,
            PageCrnkMapper pageCrnkMapper,
            RtbBlockMultistateExpressionParser rtbBlockMultistateExpressionParser,
            Policy<MobileAppSettings> pagePolicy,
            MessageSource messageSource
    ) {
        var multistateCrnkFilterValueParser = new MultistateCrnkFilterValueParser<>(
                mobileRtbBlockMultistateGraph,
                rtbBlockMultistateExpressionParser
        );
        var authenticationFacade = requestAuthorizationService.getAuthenticationFacade();
        List<ApiModelPart<MobileRtbBlock>> modelParts = new ArrayList<ApiModelPart<MobileRtbBlock>>(
                List.of(
                        new ApiMobileRtbBaseBlockModelPart(
                                crnkFilterParser,
                                mobileAppCrnkModelFilters,
                                requestAuthorizationService,
                                mobileAppSettingsAuthorizationPolicy, // todo
                                BlockUniqueIdConverter.Prefixes.MOBILE_RTB_PREFIX,
                                reachablePageService,
                                () -> pageReachabilityService.reachablePagesFilter(pageApiModel)
                                        .and(pageReachabilityService.getNotProtectedFilter()),
                                MobileAppSettings.class,
                                needPageIdFilter
                        ),
                        new ApiAdfoxBlockModelPart<>(),
                        new ApiTagsModelPart<>(apiMobileRtbMetaData.getResourceType(), tagService,
                                new BaseGodModeAvailable<>()),
                        new ApiReadonlyModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                new BaseGodModeAvailable<>()),
                        new ApiCustomBkOptionsModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                customBkOptionsTypedRepository, new BaseGodModeAvailable<>()),
                        new ApiCreateDateModelPart<>(),
                        new ApiCustomBkDataModelPart<>(apiMobileRtbMetaData.getResourceType()),
                        new ApiGeoModelPart<>(apiMobileRtbMetaData.getResourceType(), objectMapper),
                        new ApiCloseButtonDelayModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                new BaseGodModeAvailable<>()),
                        new ApiPlaceIdModelPart<>(apiMobileRtbMetaData.getResourceType(), new BaseGodModeAvailable<>()),
                        new ApiIsMobileMediationModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                new BaseGodModeAvailable<>()),
                        new ApiMobileRtbShowVideoModelPart<>(
                                apiMobileRtbMetaData.getResourceType(),
                                new ShowVideoAvailableByBlockType<>(
                                        apiMobileRtbMetaData.getResourceType(),
                                        showVideoApplicableService
                                ),
                                new BaseGodModeAvailable<>()
                        ),
                        new ApiActionsModelPart<>(
                                blockBlockActionsAuthorizationService.getAllRequiredProperties(),
                                blockBlockActionsAuthorizationService,
                                mobileRtbBlockMultistateGraph,
                                multistateService
                        ),
                        new ApiFieldsDependsModelPart<>(DEPENDS_HOLDER),
                        new ApiBrandsModelPart<>(),
                        new ApiMobileRtbCommonModelPart<>(apiMobileRtbMetaData.getResourceType()),
                        new ApiPiCategoriesModelPart<>(apiMobileRtbMetaData.getResourceType()),
                        new ApiExternalMobileRtbStrategyModelPart(apiMobileRtbMetaData.getResourceType(),
                                new ShowVideoAvailableByBlockType<>(apiMobileRtbMetaData.getResourceType(),
                                        showVideoApplicableService), new BaseGodModeAvailable<>(),
                                strategyDefaultsFieldsService, showVideoApplicableService, messageSource),
                        new ApiMobileAppModeModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                new BaseGodModeAvailable<>()),
                        new ApiMobileRtbDspsModelPart(apiMobileRtbMetaData.getResourceType(),
                                dspService,
                                reachablePageService),
                        new ApiMobileRewardModelPart<>(apiMobileRtbMetaData.getResourceType()),
                        new ApiMobileCpmCurrencyModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                reachablePageService, () -> pageReachabilityService.reachablePagesFilter(pageApiModel)
                                .and(pageReachabilityService.getNotProtectedFilter())),
                        new ApiMobileBlockTypeModelPart<>(
                                MobileBlockType.forSimpleInapp(),
                                reachablePageService, () -> pageReachabilityService.reachablePagesFilter(pageApiModel)
                                .and(pageReachabilityService.getNotProtectedFilter()),
                                messageSource, MobileAppSettings.class),
                        new ApiMobileRichMediaModelPart<>(apiMobileRtbMetaData.getResourceType()
                        ),
                        new ApiMultistateModelPart<>(multistateService, MobileRtbBlock.MULTISTATE),
                        new ApiMobileCampaignModelPart<>(pageApiModel, pageCrnkMapper, authenticationFacade,
                                crnkFilterParser, requestAuthorizationService, pagePolicy, mobileAppCrnkModelFilters),
                        new ApiMultistateFieldsModelPart<>(multistateCrnkFilterValueParser),
                        new ApiIsBiddingModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                new BaseGodModeAvailable<>()),
                        new ApiIsExternalMediationModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                new BaseGodModeAvailable<>()),
                        new ApiShowSliderModelPart<>(apiMobileRtbMetaData.getResourceType(),
                                new BaseGodModeAvailable<>()),
                        new ApiIgnoredCompatFieldsModelPart<>(
                                apiMobileRtbMetaData.getResourceType(),
                                showVideoApplicableService,
                                List.of(
                                        "media_block",
                                        // to implement or remove in perl?
                                        "articles",
                                        // RTB design fields
                                        "adaptive_height",
                                        "adaptive_width",
                                        "bg_color",
                                        "border_color",
                                        "border_radius",
                                        "border_type",
                                        "callouts",
                                        "favicon",
                                        "font_family",
                                        "font_size",
                                        "hover_color",
                                        "links_underline",
                                        "no_sitelinks",
                                        "site_bg_color",
                                        "sitelinks_color",
                                        "text_color",
                                        "title_color",
                                        "title_font_size",
                                        "url_background_color",
                                        "url_color",
                                        "header_bg_color",
                                        "direct_block",
                                        "horizontal_align",
                                        "dsp_blocks"
                                )),
                        new ApiDspModeModelPart<>(apiMobileRtbMetaData.getResourceType(), new BaseGodModeAvailable<>())
                ));

        ApiFieldsAccessRulesService<MobileRtbBlock> availableService =
                ConfigurationUtils.INSTANCE.configureAvailableFields(
                        modelParts,
                        mobileRtbBlockAccessFunctionComposite,
                        requestAuthorizationService.getAuthenticationFacade(),
                        null
                );

        ApiFieldsAccessRulesService<EditableData<MobileRtbBlock>> editableService =
                ConfigurationUtils.INSTANCE.configureEditableFields(
                        modelParts,
                        mobileRtbBlockAccessFunctionComposite,
                        requestAuthorizationService.getAuthenticationFacade(),
                        blockBlockActionsAuthorizationService,
                        editableFieldsService
                );

        return new ApiMobileRtbModel(
                apiMobileRtbMetaData,
                modelParts,
                availableService,
                editableService,
                mobileRtbBlockAuthorizationPolicy
        );
    }
}
