package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ApiResourceType;
import ru.yandex.partner.jsonapi.models.block.relationships.PageOneApiRelationship;
import ru.yandex.partner.jsonapi.models.relationships.ApiRelationship;
import ru.yandex.partner.libs.authorization.policy.base.Policy;


public class ApiMobileRtbModel extends AbstractApiModel<MobileRtbBlock> {
    private final Policy<MobileRtbBlock> policy;
    private final List<ApiRelationship<MobileRtbBlock>> relationships;

    public ApiMobileRtbModel(ApiModelMetaData<MobileRtbBlock> apiModelMetaData,
                             List<ApiModelPart<MobileRtbBlock>> apiModelParts,
                             ApiFieldsAccessRulesService<MobileRtbBlock> apiFieldsAvailableRules,
                             ApiFieldsAccessRulesService<EditableData<MobileRtbBlock>> apiFieldsEditableRules,
                             Policy<MobileRtbBlock> policy) {
        super(apiModelMetaData, apiModelParts, apiFieldsAvailableRules, apiFieldsEditableRules);
        this.policy = policy;
        this.relationships = List.of(
                new PageOneApiRelationship<>(ApiResourceType.MOBILE_APP_SETTINGS)
        );
    }

    @Override
    public MobileRtbBlock createNewInstance() {
        return new MobileRtbBlock();
    }

    @Override
    public Policy<MobileRtbBlock> getPolicy() {
        return policy;
    }

    @Override
    public MetaFilter<? super MobileRtbBlock, Long> getIdFilter() {
        return BlockFilters.ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Map.of(
                "mobile_app_settings", Map.of(
                        "self", "relationships/mobile_app_settings",
                        "related", "mobile_app_settings"),

                "pages", Map.of(
                        "self", "relationships/pages",
                        "related", "pages")
        );
    }

    @Override
    public List<ApiRelationship<MobileRtbBlock>> getApiRelationships() {
        return relationships;
    }
}
