package ru.yandex.partner.jsonapi.models.block.rtb.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.jsonapi.crnk.page.ExternalPageReachabilityService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.block.AuthBlockContainerConfigurer;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

@Component
public class MobileRtbAuthBlockContainerConfigurer
        extends AuthBlockContainerConfigurer<MobileRtbBlock, MobileAppSettings> {
    @Autowired
    public MobileRtbAuthBlockContainerConfigurer(AuthenticationFacade authenticationFacade,
                                                 ExternalPageReachabilityService pageReachabilityService,
                                                 ApiModel<MobileRtbBlock> blockApiModel,
                                                 ApiModel<MobileAppSettings> pageApiModel) {
        super(authenticationFacade, pageReachabilityService, blockApiModel, pageApiModel);
    }

    @Override
    public Class getModelClass() {
        return MobileRtbBlock.class;
    }
}
