package ru.yandex.partner.jsonapi.models.block.rtb.mobile.internal;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.BlockWithInternalMobileApp;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.multistate.page.PageStateFlag;
import ru.yandex.partner.core.page.MobileStoreType;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.block.BlockCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.UserTypeDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.expose.CheckRightsCrnkFilterExposeStrategy;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.filter.parser.values.MatchCrnkFilterValueParser;
import ru.yandex.partner.jsonapi.crnk.page.MobileAppCrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkMapper;
import ru.yandex.partner.jsonapi.crnk.page.PageRightsEnum;
import ru.yandex.partner.jsonapi.crnk.page.models.InternalMobileAppForBlockCrnk;
import ru.yandex.partner.jsonapi.crnk.user.UserCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.user.UserCrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum;
import ru.yandex.partner.jsonapi.crnk.user.filter.parser.UserTypeCrnkFilterValueParser;
import ru.yandex.partner.jsonapi.messages.block.RtbMsg;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.block.BlockFilterNameEnum;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkableByRight;
import static ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum.VIEW_SEARCH_FILTERS__APP_ID;
import static ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum.VIEW_SEARCH_FILTERS__CLIENT_ID;

public class ApiInternalMobileCampaignModelPart<B extends BlockWithInternalMobileApp, P extends BasePage>
        implements ApiModelPart<B> {
    private final ApiModelMetaData<InternalMobileApp> apiModelMetaData;
    private final PageCrnkMapper pageCrnkMapper;
    private final AuthenticationFacade authenticationFacade;
    private final CrnkFilterParser crnkFilterParser;
    private final RequestAuthorizationService requestAuthorizationService;
    private final Policy<P> pagePolicy;
    private final CrnkModelFilters<P> pageCrnkModelFilters;

    public ApiInternalMobileCampaignModelPart(ApiModelMetaData<InternalMobileApp> apiModelMetaData,
                                              PageCrnkMapper pageCrnkMapper, AuthenticationFacade authenticationFacade,
                                              CrnkFilterParser crnkFilterParser,
                                              RequestAuthorizationService requestAuthorizationService,
                                              Policy<P> pagePolicy,
                                              CrnkModelFilters<P> pageCrnkModelFilters) {
        this.apiModelMetaData = apiModelMetaData;
        this.pageCrnkMapper = pageCrnkMapper;
        this.authenticationFacade = authenticationFacade;
        this.crnkFilterParser = crnkFilterParser;
        this.requestAuthorizationService = requestAuthorizationService;
        this.pagePolicy = pagePolicy;
        this.pageCrnkModelFilters = pageCrnkModelFilters;
    }

    @Override
    public List<ApiField<B>> getFields() {
        return List.of(
                ApiField.readableApiField(
                                InternalMobileAppForBlockCrnk.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, InternalMobileAppForBlockCrnk>one(block ->
                                        pageCrnkMapper.internalMobileAppToInternalMobileAppForBlockCrnk(
                                                block.getCampaign(), Set.of(),
                                                authenticationFacade.getUserAuthentication().getUid())))
                        .addCheckInnerField(
                                PageRightsEnum.VIEW_FIELD__DOMAIN_ID.getFullRightName(
                                        apiModelMetaData.getResourceType()),
                                PageCrnkJsonFieldAliases.DOMAIN_ID)
                        .addCheckInnerField(UserRightsEnum.VIEW_FIELD__IS_TUTBY,
                                PageCrnkJsonFieldAliases.OWNER,
                                UserCrnkJsonFieldAliases.IS_TUTBY)
                        .addCheckInnerField(UserRightsEnum.VIEW_FIELD__ROLES,
                                PageCrnkJsonFieldAliases.OWNER,
                                UserCrnkJsonFieldAliases.ROLES)
                        .build(BlockCrnkJsonFieldAliases.APPLICATION),
                ApiField
                        .readableApiField(
                                Long.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, Long>one(block -> block.getCampaign().getBlocksCount()))
                        .build(BlockCrnkJsonFieldAliases.BLOCKS_COUNT),
                ApiField
                        .readableApiField(
                                Long.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, Long>one(block -> block.getCampaign().getBlocksLimit()))
                        .build(BlockCrnkJsonFieldAliases.BLOCKS_LIMIT),
                ApiField
                        .readableApiField(
                                String.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, String>one(block -> block.getCampaign().getDomain()))
                        .build(BlockCrnkJsonFieldAliases.DOMAIN),
                ApiField
                        .readableApiField(
                                String.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, String>one(block -> block.getCampaign().getStoreId()))
                        .build(BlockCrnkJsonFieldAliases.STORE_ID),
                ApiField
                        .readableApiField(Boolean.class, B.CAMPAIGN,
                                BatchFunction.one(this::isCampaignDeleted))
                        .build(BlockCrnkJsonFieldAliases.IS_APPLICATION_DELETED),
                ApiField
                        .readableApiField(Boolean.class, B.CAMPAIGN,
                                BatchFunction.one(this::isCampaignDeleted))
                        .build(BlockCrnkJsonFieldAliases.IS_PAGE_DELETED),
                ApiField
                        .readableApiField(
                                Long.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, Long>one(block -> block.getCampaign().getOwnerId()))
                        .build(BlockCrnkJsonFieldAliases.OWNER_ID),
                ApiField
                        .readableApiField(
                                String.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, String>one(block -> Optional.ofNullable(block)
                                        .map(B::getCampaign)
                                        .map(InternalMobileApp::getOwner)
                                        .map(User::getLogin)
                                        .orElse(null)))
                        .withAvailableFunction(checkableByRight(
                                PageRightsEnum.VIEW_FIELD__LOGIN.getFullRightName(apiModelMetaData.getResourceType())))
                        .build(BlockCrnkJsonFieldAliases.LOGIN),
                ApiField
                        .readableApiField(String.class, B.CAMPAIGN,
                                BatchFunction.<B, String>one(block -> block.getCampaign().getCaption()))
                        .build(BlockCrnkJsonFieldAliases.APPLICATION_CAPTION),
                ApiField
                        .readableApiField(String.class, B.CAMPAIGN,
                                BatchFunction.<B, String>one(block -> {
                                    Long type = block.getCampaign().getType();
                                    return type == null ? null : MobileStoreType.getById(type).getCaption();
                                }))
                        .build(BlockCrnkJsonFieldAliases.APPLICATION_PLATFORM),
                ApiField
                        .readableApiField(
                                Long.class,
                                B.CAMPAIGN,
                                BatchFunction.<B, Long>one(block -> block.getCampaign().getApplicationId()))
                        .build(BlockCrnkJsonFieldAliases.APPLICATION_ID)
        );
    }

    @Override
    public Map<String, CrnkFilter<B, ?>> getFilters() {
        CheckRightsCrnkFilterExposeStrategy.Factory exposeFactory
                = new CheckRightsCrnkFilterExposeStrategy.Factory(authenticationFacade);

        MatchCrnkFilterValueParser<BasePage> pageMatchCrnkFilterValueParser =
                new MatchCrnkFilterValueParser<>(crnkFilterParser,
                        requestAuthorizationService,
                        pageCrnkModelFilters,
                        pagePolicy);

        var list = List.<CrnkFilter<B, ?>>of(
                CrnkFilter.builder(BlockFilterNameEnum.LOGIN)
                        .setLabel(RtbMsg.LOGIN)
                        .setExposed(exposeFactory.forRights(UserRightsEnum.VIEW_SEARCH_FILTERS__LOGIN))
                        .toCrnkFilter(BlockFilters.LOGIN),

                CrnkFilter.builder(BlockFilterNameEnum.USER_TYPE)
                        .setLabel(RtbMsg.USER_TYPE)
                        .setExposed(exposeFactory.forRights(UserRightsEnum.VIEW_SEARCH_FILTERS__USER_TYPE))
                        .toCrnkFilter(
                                BlockFilters.USER_TYPE,
                                new UserTypeCrnkFilterValueParser(authenticationFacade),
                                new UserTypeDictionaryValuesProvider(authenticationFacade)
                        ),
                CrnkFilter.builder(BlockFilterNameEnum.APPLICATION)
                        .toCrnkFilterMatch(
                                BlockFilters.PAGE,
                                pageMatchCrnkFilterValueParser,
                                CrnkFilter.builder(MobileAppCrnkModelFilters.FilterNameEnum.APPLICATION_ID)
                                        .setLabel(RtbMsg.APP_ID)
                                        .setExposed(exposeFactory.forRights(VIEW_SEARCH_FILTERS__APP_ID)),
                                CrnkFilter.builder(BlockFilterNameEnum.APPLICATION, BlockFilterNameEnum.STORE_ID)
                                        .setLabel(RtbMsg.STORE_ID)
                                        .setExposed(() -> true),
                                CrnkFilter.builder(
                                        MobileAppCrnkModelFilters.FilterNameEnum.OWNER,
                                                UserCrnkModelFilters.NameEnum.CLIENT_ID)
                                        .setLabel(RtbMsg.CLIENT_ID)
                                        .setExposed(exposeFactory.forRights(VIEW_SEARCH_FILTERS__CLIENT_ID)),
                                CrnkFilter.builder(BlockFilterNameEnum.APPLICATION, BlockFilterNameEnum.PLATFORM)
                                        .setLabel(RtbMsg.PLATFORM)
                                        .setExposed(() -> true)
                                )
        );

        return list.stream()
                .collect(Collectors.toMap(
                        CrnkFilter::getName,
                        baseBlockCrnkFilter -> baseBlockCrnkFilter
                ));
    }

    private Boolean isCampaignDeleted(B block) {
        var campaign = block.getCampaign();
        return campaign.getMultistate() == null
                ? null
                : campaign.getMultistate().test(PageStateFlag.DELETED);
    }
}
