package ru.yandex.partner.jsonapi.models.block.rtb.mobile.internal;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.service.ReachablePageService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.page.MobileStoreType;
import ru.yandex.partner.jsonapi.crnk.CrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.models.block.parts.ApiBaseBlockModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class ApiInternalMobileRtbBaseBlockModelPart
        extends ApiBaseBlockModelPart<InternalMobileRtbBlock, InternalMobileApp> {

    @SuppressWarnings("checkstyle:parameternumber")
    public ApiInternalMobileRtbBaseBlockModelPart(CrnkFilterParser crnkFilterParser,
                                                  CrnkModelFilters<InternalMobileApp> pageCrnkModelFilters,
                                                  RequestAuthorizationService requestAuthorizationService,
                                                  Policy<InternalMobileApp> pagePolicy,
                                                  BlockUniqueIdConverter.Prefixes prefix,
                                                  ReachablePageService<InternalMobileRtbBlock> reachablePageService,
                                                  Supplier<CoreFilterNode<InternalMobileApp>> authPageFilterProvider,
                                                  Class<InternalMobileApp> pageClass, boolean needPageIdFilter) {
        super(crnkFilterParser, pageCrnkModelFilters, requestAuthorizationService, pagePolicy, prefix,
                reachablePageService, authPageFilterProvider, pageClass, needPageIdFilter);
    }

    @Override
    protected Function<InternalMobileApp, Map<String, Object>> pageMapper() {
        return page -> {
            MobileStoreType storeType = MobileStoreType.getById(page.getType());
            return Map.of(
                    PageCrnkJsonFieldAliases.CAPTION, page.getCaption(),
                    PageCrnkJsonFieldAliases.DOMAIN, page.getDomain(),
                    PageCrnkJsonFieldAliases.PAGE_ID, page.getId().toString(),
                    PageCrnkJsonFieldAliases.OWNER_ID, page.getOwnerId().toString()
                    //TODO
            );
        };
    }
}
