package ru.yandex.partner.jsonapi.models.block.rtb.mobile.internal;

import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.model.prop.BlockWithCustomBkDataFlagIsCustomBkDataPropHolder;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesFunction;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.block.BlockRightNames;
import ru.yandex.partner.jsonapi.models.block.access.NotCustomBkDataAccessRuleFunction;
import ru.yandex.partner.jsonapi.models.block.parts.ApiCommonModelPart;

public class ApiInternalMobileRtbCommonModelPart<B extends BlockWithCommonFields
        & BlockWithCustomBkDataFlagIsCustomBkDataPropHolder>
        extends ApiCommonModelPart<B> {

    private final ApiFieldsAccessRulesFunction<B> godModeFunction;

    public ApiInternalMobileRtbCommonModelPart(String modelName) {
        super(modelName);
        godModeFunction = new NotCustomBkDataAccessRuleFunction<>();
    }

    public ApiInternalMobileRtbCommonModelPart(String modelName, BlockRightNames editRight) {
        super(modelName, editRight);
        godModeFunction = new NotCustomBkDataAccessRuleFunction<>();
    }

    @Override
    protected ApiFieldsAccessRulesFunction<EditableData<B>> editableFunction() {
        return ApiFieldsAccessRulesFunction.alwaysAllow();
    }

    @Override
    public ApiFieldsAccessRulesFunction<B> isGodModeFunction() {
        return godModeFunction;
    }
}
