package ru.yandex.partner.jsonapi.models.block.rtb.mobile.internal;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ApiResourceType;
import ru.yandex.partner.jsonapi.models.block.relationships.PageOneApiRelationship;
import ru.yandex.partner.jsonapi.models.relationships.ApiRelationship;
import ru.yandex.partner.libs.authorization.policy.base.Policy;


public class ApiInternalMobileRtbModel extends AbstractApiModel<InternalMobileRtbBlock> {
    private final Policy<InternalMobileRtbBlock> policy;
    private final List<ApiRelationship<InternalMobileRtbBlock>> relationships;

    public ApiInternalMobileRtbModel(
            ApiModelMetaData<InternalMobileRtbBlock> apiModelMetaData,
            List<ApiModelPart<InternalMobileRtbBlock>> apiModelParts,
            ApiFieldsAccessRulesService<InternalMobileRtbBlock> apiFieldsAvailableRules,
            ApiFieldsAccessRulesService<EditableData<InternalMobileRtbBlock>> apiFieldsEditableRules,
            Policy<InternalMobileRtbBlock> policy) {
        super(apiModelMetaData, apiModelParts, apiFieldsAvailableRules, apiFieldsEditableRules);
        this.policy = policy;
        this.relationships = List.of(
                new PageOneApiRelationship<>(ApiResourceType.INTERNAL_MOBILE_APP)
        );
    }

    @Override
    public InternalMobileRtbBlock createNewInstance() {
        return new InternalMobileRtbBlock();
    }

    @Override
    public Policy<InternalMobileRtbBlock> getPolicy() {
        return policy;
    }

    @Override
    public MetaFilter<? super InternalMobileRtbBlock, Long> getIdFilter() {
        return BlockFilters.ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Map.of(
                "internal_mobile_app", Map.of(
                        "self", "relationships/internal_mobile_app",
                        "related", "internal_mobile_app"),

                "pages", Map.of(
                        "self", "relationships/pages",
                        "related", "pages")
        );
    }

    @Override
    public List<ApiRelationship<InternalMobileRtbBlock>> getApiRelationships() {
        return relationships;
    }
}
