package ru.yandex.partner.jsonapi.models.block.rtb.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.jsonapi.crnk.page.ExternalPageReachabilityService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.block.AuthBlockContainerConfigurer;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;

@Component
public class InternalMobileRtbAuthBlockContainerConfigurer
        extends AuthBlockContainerConfigurer<InternalMobileRtbBlock, InternalMobileApp> {
    @Autowired
    public InternalMobileRtbAuthBlockContainerConfigurer(AuthenticationFacade authenticationFacade,
                                                         ExternalPageReachabilityService pageReachabilityService,
                                                         ApiModel<InternalMobileRtbBlock> blockApiModel,
                                                         ApiModel<InternalMobileApp> pageApiModel) {
        super(authenticationFacade, pageReachabilityService, blockApiModel, pageApiModel);
    }

    @Override
    public Class getModelClass() {
        return InternalMobileRtbBlock.class;
    }
}
