package ru.yandex.partner.jsonapi.models.common;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.Action;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.multistate.ActionName;
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;
import ru.yandex.partner.libs.multistate.graph.AbstractMultistateGraph;

public class ApiActionsModelPart<M extends Model> implements ApiModelPart<M> {
    private final List<ModelProperty<? super M, ?>> requireProperties;
    private final AbstractMultistateGraph<? super M, ?> multistateGraph;
    private final ActionsAuthorizationService<M> actionsAuthorizationService;
    private final MultistateService multistateService;

    public ApiActionsModelPart(List<ModelProperty<? super M, ?>> requireProperties,
                               ActionsAuthorizationService<M> actionsAuthorizationService,
                               AbstractMultistateGraph<? super M, ?> multistateGraph,
                               MultistateService multistateService) {

        this.requireProperties = requireProperties;
        this.actionsAuthorizationService = actionsAuthorizationService;
        this.multistateGraph = multistateGraph;
        this.multistateService = multistateService;
    }

    @Override
    public List<ApiField<M>> getFields() {
        return List.of(
                ApiField.apiField(
                        ModelClassUtils.getMapClass(ActionName.class, String.class),
                        BatchFunction.<M, Map<ActionName, String>>one(model -> {
                            Set<Action> allowedActions = multistateGraph.getAllowedActions(model);
                            Set<Action> filteredActions =
                                    actionsAuthorizationService.filterApiActions(model, allowedActions);
                            return multistateService.renderActions(filteredActions);
                        }))
                        .withRequiredProperties(requireProperties)
                        .withAvailableFunction(getAvailableConsumer())
                        .build(CrnkConstants.ACTIONS_FIELD_NAME)
        );
    }

    protected BiConsumer<String, ApiFieldsAccessRules.Builder<M>> getAvailableConsumer() {
        return ApiFieldsAccessRules.alwaysPermit();
    }
}
