package ru.yandex.partner.jsonapi.models.common

import ru.yandex.direct.model.Model
import ru.yandex.partner.jsonapi.constants.CrnkConstants
import ru.yandex.partner.jsonapi.crnk.fields.ApiField
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService
import ru.yandex.partner.jsonapi.models.ApiModelPart
import ru.yandex.partner.jsonapi.models.ModelClassUtils
import ru.yandex.partner.jsonapi.utils.FieldsCompatibilityService
import ru.yandex.partner.jsonapi.utils.function.BatchFunction
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade


class ApiAvailableFieldsModelPart<M : Model>(
    private val apiFieldsAvailableRules: ApiFieldsAccessRulesService<M>,
    private val authenticationFacade: AuthenticationFacade,
    private val availableFieldJsonName: String,
    private val editableFieldJsonName: String,
    private val fieldsCompatibilityService: FieldsCompatibilityService?
) : ApiModelPart<M> {

    override fun getFields(): List<ApiField<M>> {
        return mutableListOf(
            ApiField.apiField(
                ModelClassUtils.getMapClass(String::class.java, Boolean::class.java),
                BatchFunction.one<M, Map<String, Boolean>> { model: M ->
                    apiFieldsAvailableRules.calculate(authenticationFacade.userAuthentication, model)
                        .map { it to true }
                        .plus(availableFieldJsonName to true)
                        .plus(editableFieldJsonName to true)
                        .plus(fieldsCompatibilityService
                            ?.extraAvailableFields?.map { it to true } ?: emptyList() )
                        .toMap()
                })
                .build(CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME)
        )
    }
}
