package ru.yandex.partner.jsonapi.models.common

import ru.yandex.direct.model.ModelWithId
import ru.yandex.partner.core.entity.block.model.BlockWithStrategy
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.jsonapi.constants.CrnkConstants
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.fields.ApiField
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService
import ru.yandex.partner.jsonapi.crnk.fields.EditableData
import ru.yandex.partner.jsonapi.models.ApiModelPart
import ru.yandex.partner.jsonapi.models.ModelClassUtils
import ru.yandex.partner.jsonapi.utils.function.BatchFunction
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade

class ApiEditableFieldsModelPart<M : ModelWithId>(
    private val apiFieldsEditableRules: ApiFieldsAccessRulesService<EditableData<M>>,
    private val authenticationFacade: AuthenticationFacade,
    private val actionsAuthorizationService: ActionsAuthorizationService<M>,
    private val editableFieldsService: EditableFieldsService<in M>,
    private val apiFields: List<ApiField<M>>
) : ApiModelPart<M> {

    override fun getFields(): MutableList<ApiField<M>> {
        val allStrategyProperties = BlockWithStrategy.allModelProperties()
        return mutableListOf(
            ApiField
                .apiField(ModelClassUtils.getMapClass(String::class.java, Boolean::class.java),
                    BatchFunction.one<M, Map<String, Boolean>> { model: M ->
                        // can_action edit found here
                        if (actionsAuthorizationService.checkActionAllowedAndAuthorized(
                                CrnkConstants.ACTION_EDIT_NAME,
                                model)) {
                            val coreEditableProps = editableFieldsService.calculateEditableModelPropertiesHolder(model)
                                .enableProperties.flatten().associateWith { true }

                            val coreApiMerged = apiFields.associate {
                                it.jsonName to
                                    if (it.modelPath == null) {
                                        // поле торчит только в апи, его доступность будет определяться дальше
                                        true
                                    } else {
                                        if (allStrategyProperties
                                                .contains(it.modelPath.lastProperty())){
                                            // Костыль, связанный с плоской стратегией. Ранее код ниже добавлял
                                            // в список editable_fields все поля подмодели, т.к. фронт ожидает все поля
                                            // стратегии как редактируемые, независимо от типа стратегии, а логика в
                                            // CoreModel фильтрует список редактируемых полей в зависимости от типа
                                            // https://st.yandex-team.ru/PI-27538
                                                coreEditableProps.getOrDefault(BlockWithStrategy.STRATEGY_TYPE, false)

                                        } else{
                                            // если проперти нет среди разрешенных для редактирования в
                                            // Core слое значит false
                                            coreEditableProps.getOrDefault(it.modelPath.rootProperty(), false)

                                        }
                                    }
                            }
                            // ищем редактируемые поля по правилам АПИ и мержим их с правилами для core слоя
                            apiFieldsEditableRules
                                .calculate(authenticationFacade.userAuthentication, EditableData(model))
                                .associateWith { coreApiMerged[it]!! }
                                .filter { it.value }
                                .toMap()

                        } else {
                            emptyMap()
                        }
                    })
                .build(CrnkConstants.EDITABLE_FIELDS_FIELD_NAME)
        )
    }
}
