package ru.yandex.partner.jsonapi.models.common;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

import ru.yandex.direct.model.Model;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.DependsHolder;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;

public class ApiFieldsDependsModelPart<M extends Model> implements ApiModelPart<M> {
    private final DependsHolder fieldsDepends;
    private boolean hide = false;

    public ApiFieldsDependsModelPart(DependsHolder fieldsDepends) {
        this.fieldsDepends = fieldsDepends;
    }

    @Override
    public Optional<DependsHolder> getDepends() {
        return Optional.of(fieldsDepends);
    }

    public ApiFieldsDependsModelPart<M> setHide(boolean hide) {
        this.hide = hide;
        return this;
    }

    @Override
    public List<ApiField<M>> getFields() {
        var builders = List.of(
                ApiField
                        .apiField(ModelClassUtils.getMapClass(String.class, Map.class),
                                BatchFunction.<M, Map<String, Map<String, List<String>>>>one(model
                                        -> fieldsDepends.toMap()))
        );
        if (hide) {
            builders.forEach(it -> it.withAvailableFunction(ApiFieldsAccessRules.neverPermit()));
        }
        return builders.stream().map(it -> it.build(CrnkConstants.FIELDS_DEPENDS)).collect(Collectors.toList());
    }
}
