package ru.yandex.partner.jsonapi.models.common;

import java.util.List;
import java.util.function.BiConsumer;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.StateFlag;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.sameAs;

/**
 * @param <P> *PropHolder
 * @param <M> Model
 * @param <S> StateFlag
 */
public class ApiMultistateModelPart<P extends Model, M extends P, S extends StateFlag> implements ApiModelPart<M> {
    private final MultistateService multistateService;
    private final ModelProperty<P, ? extends Multistate<S>> multistateModelProperty;

    public ApiMultistateModelPart(MultistateService multistateService,
                                  ModelProperty<P, ? extends Multistate<S>> multistateModelProperty) {
        this.multistateService = multistateService;
        this.multistateModelProperty = multistateModelProperty;
    }

    @Override
    public List<ApiField<M>> getFields() {
        var apiFieldMultistate = ApiField.readableApiField(
                Long.class,
                multistateModelProperty,
                BatchFunction.<M, Long>one(model -> {
                    Multistate<S> multistate = multistateModelProperty.get(model);
                    return multistate == null
                            ? null
                            : multistate.toMultistateValue();
                }))
                .withAvailableFunction(getAvailableConsumer())
                .build(CrnkConstants.MULTISTATE_FIELD_NAME);

        return List.of(
                apiFieldMultistate,
                ApiField.readableApiField(
                        String.class,
                        multistateModelProperty,
                        BatchFunction.<M, String>one(model -> {
                            Multistate<S> multistate = multistateModelProperty.get(model);

                            return multistate == null
                                    ? null
                                    : multistateService.renderMultistateName(multistate);
                        }))
                        .withAvailableFunction(sameAs(apiFieldMultistate))
                        .build(CrnkConstants.MULTISTATE_NAME_FIELD_NAME)
        );
    }

    protected BiConsumer<String, ApiFieldsAccessRules.Builder<M>> getAvailableConsumer() {
        return ApiFieldsAccessRules.alwaysPermit();
    }
}
