package ru.yandex.partner.jsonapi.models.common;

import java.util.List;

import ru.yandex.direct.model.Model;
import ru.yandex.partner.jsonapi.constants.CrnkConstants;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.jsonapi.models.ModelClassUtils;
import ru.yandex.partner.jsonapi.utils.function.BatchFunction;

public class ApiRequireFieldsModelPart<M extends Model> implements ApiModelPart<M> {
    private final List<String> requiredFields;

    public ApiRequireFieldsModelPart(List<String> requiredFields) {
        this.requiredFields = requiredFields;
    }

    @Override
    public List<ApiField<M>> getFields() {
        return List.of(
                ApiField
                        .apiField(
                                ModelClassUtils.getListClass(String.class),
                                BatchFunction.<M, List<String>>one(block -> requiredFields))
                        .build(CrnkConstants.REQUIRED_FIELDS)
        );
    }
}
