package ru.yandex.partner.jsonapi.models.designtemplates;

import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.designtemplates.filter.DesignTemplatesFilters;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.designtemplates.authorization.DesignTemplatesAuthorizationPolicy;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

//TODO: заготовка на будущее
public class ApiDesignTemplatesModel extends AbstractApiModel<DesignTemplates> {
    private final DesignTemplatesAuthorizationPolicy policy;

    public ApiDesignTemplatesModel(ApiDesignTemplatesModelMetaData apiDesignTemplatesModelMetaData,
                                   List<ApiModelPart<DesignTemplates>> apiModelParts,
                                   DesignTemplatesAuthorizationPolicy policy,
                                   ApiFieldsAccessRulesService<DesignTemplates> apiFieldsAvailableRules,
                                   ApiFieldsAccessRulesService<EditableData<DesignTemplates>> apiFieldsEditableRules) {
        super(apiDesignTemplatesModelMetaData, apiModelParts,
                apiFieldsAvailableRules, apiFieldsEditableRules);
        this.policy = policy;
    }

    @Override
    public DesignTemplates createNewInstance() {
        return new DesignTemplates();
    }

    @Override
    public Policy<DesignTemplates> getPolicy() {
        return policy;
    }

    @Override
    public MetaFilter<? super DesignTemplates, Long> getIdFilter() {
        return DesignTemplatesFilters.ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Map.of();
    }
}
