package ru.yandex.partner.jsonapi.models.designtemplates;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.designtemplates.model.CommonDesignTemplates;
import ru.yandex.partner.core.entity.designtemplates.service.DesignTemplatesService;
import ru.yandex.partner.jsonapi.crnk.DummyActionAllowedAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.models.AbstractApiService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.actions.ActionService;
import ru.yandex.partner.libs.i18n.TranslatableError;

@ParametersAreNonnullByDefault
public class ApiDesignTemplatesService<D extends CommonDesignTemplates> extends AbstractApiService<D> {

    public ApiDesignTemplatesService(DefectPresentationRegistry<TranslatableError> defectRegistry,
                                     DesignTemplatesService modelService,
                                     RequestAuthorizationService requestAuthorizationService,
                                     ApiFieldsService<D> apiFieldsService,
                                     ApiModel<D> apiModel,
                                     ActionService<D> actionService,
                                     ActionPerformer actionPerformer) {
        super(defectRegistry, modelService, requestAuthorizationService,
                new DummyActionAllowedAuthorizationService<>(requestAuthorizationService, apiModel),
                apiFieldsService,
                apiModel, actionService, actionPerformer
        );
    }

    @Override
    public String coreIdToApiId(Long id) {
        return String.valueOf(id);
    }

    @Override
    public Long apiIdToCoreId(String id) {
        return Long.parseLong(id);
    }
}
