package ru.yandex.partner.jsonapi.models.designtemplates;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilterName;

@ParametersAreNonnullByDefault
public enum DesignTemplatesFilterNameEnum implements CrnkFilterName {
    BLOCK_ID("block_id"),
    PAGE_ID("page_id"),
    ID("id"),
    CAPTION("caption"),
    MULTISTATE("multistate");

    private final String name;

    DesignTemplatesFilterNameEnum(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return name;
    }
}
