package ru.yandex.partner.jsonapi.models.kvstorefrontend;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import io.crnk.core.engine.information.resource.ResourceFieldType;

import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.filter.KvStoreFrontendFilters;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

@ParametersAreNonnullByDefault
public class ApiFieldKvStoreFrontendModelPart implements ApiModelPart<KvStoreFrontend> {
    private static final String ID = "id";
    private static final String USER_ID = "user_id";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String CREATE_TIME = "create_time";
    private static final String UPDATE_TIME = "update_time";

    @Override
    public List<ApiField<KvStoreFrontend>> getFields() {

        return List.of(
                ApiField.convertibleApiField(Long.class, KvStoreFrontend.ID)
                        .withResourceFieldType(ResourceFieldType.ID)
                        .withAddFieldFunction(ApiFieldsAccessRules.alwaysPermit())
                        .build(ID),
                ApiField.convertibleApiField(Long.class, KvStoreFrontend.USER_ID)
                        .withAddFieldFunction(ApiFieldsAccessRules.alwaysPermit())
                        .build(USER_ID),
                ApiField.convertibleApiField(String.class, KvStoreFrontend.KEY)
                        .withAddFieldFunction(ApiFieldsAccessRules.alwaysPermit())
                        .build(KEY),
                ApiField.convertibleApiField(String.class, KvStoreFrontend.VALUE)
                        .withAddFieldFunction(ApiFieldsAccessRules.alwaysPermit())
                        .build(VALUE),
                ApiField.convertibleApiField(LocalDateTime.class, KvStoreFrontend.CREATE_TIME)
                        .withAddFieldFunction(ApiFieldsAccessRules.alwaysPermit())
                        .build(CREATE_TIME),
                ApiField.convertibleApiField(LocalDateTime.class, KvStoreFrontend.UPDATE_TIME)
                        .withAddFieldFunction(ApiFieldsAccessRules.alwaysPermit())
                        .build(UPDATE_TIME)
        );
    }

    @Override
    public Map<String, CrnkFilter<KvStoreFrontend, ?>> getFilters() {
        List<CrnkFilter<KvStoreFrontend, ?>> filtersList = List.of(
                CrnkFilter.builder(KvStoreFrontFilterNameEnum.USER_ID)
                        .toCrnkFilter(KvStoreFrontendFilters.USER_ID),
                CrnkFilter.builder(KvStoreFrontFilterNameEnum.KEY)
                        .toCrnkFilter(KvStoreFrontendFilters.KEY),
                CrnkFilter.builder(KvStoreFrontFilterNameEnum.ID)
                        .toCrnkFilter(KvStoreFrontendFilters.ID)
        );

        return filtersList.stream()
                .collect(Collectors.toMap(
                        CrnkFilter::getName, it -> it
                ));
    }
}
