package ru.yandex.partner.jsonapi.models.kvstorefrontend;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.filter.KvStoreFrontendFilters;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

@ParametersAreNonnullByDefault
public class ApiKvFrontendModel extends AbstractApiModel<KvStoreFrontend> {
    private final Policy<KvStoreFrontend> policy;

    public ApiKvFrontendModel(ApiKvFrontendModelMetaData apiKvFrontendModelMetaData,
                              List<ApiModelPart<KvStoreFrontend>> apiModelParts,
                              Policy<KvStoreFrontend> policy,
                              ApiFieldsAccessRulesService<KvStoreFrontend> apiFieldsAvailableRules,
                              ApiFieldsAccessRulesService<EditableData<KvStoreFrontend>> apiFieldsEditableRules) {
        super(apiKvFrontendModelMetaData, apiModelParts, apiFieldsAvailableRules, apiFieldsEditableRules);
        this.policy = policy;
    }

    @Override
    public MetaFilter<? super KvStoreFrontend, Long> getIdFilter() {
        return KvStoreFrontendFilters.ID;
    }

    @Override
    public KvStoreFrontend createNewInstance() {
        return new KvStoreFrontend();
    }

    @Override
    public Policy<KvStoreFrontend> getPolicy() {
        return policy;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Map.of();
    }
}
