package ru.yandex.partner.jsonapi.models.kvstorefrontend;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.result.ActionsResult;
import ru.yandex.partner.core.entity.QueryOpts;
import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.filter.KvStoreFrontendFilters;
import ru.yandex.partner.core.entity.simplemodels.kvstorefrontend.service.KvStoreFrontendService;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.jsonapi.crnk.fields.IncomingApiFields;
import ru.yandex.partner.jsonapi.crnk.kvstorefrontend.KvStoreFrontendApiFieldsService;
import ru.yandex.partner.jsonapi.models.AbstractApiService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.kvstorefrontend.actions.KvStoreFrontendActionsService;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;
import ru.yandex.partner.libs.i18n.TranslatableError;

import static ru.yandex.partner.core.filter.CoreFilterNode.and;

@ParametersAreNonnullByDefault
@Service
public class ApiKvFrontendService extends AbstractApiService<KvStoreFrontend> {
    private final KvStoreFrontendService kvStoreFrontendService;

    @Autowired
    public ApiKvFrontendService(
            DefectPresentationRegistry<TranslatableError> defectRegistry,
            RequestAuthorizationService requestAuthorizationService,
            KvStoreFrontendApiFieldsService apiFieldsService,
            ApiModel<KvStoreFrontend> apiModel,
            KvStoreFrontendService kvStoreFrontendService,
            KvStoreFrontendActionsService actionsService,
            ActionPerformer actionPerformer
    ) {
        super(
                defectRegistry,
                kvStoreFrontendService,
                requestAuthorizationService,
                apiFieldsService,
                apiModel,
                actionsService,
                actionPerformer
        );
        this.kvStoreFrontendService = kvStoreFrontendService;
    }

    @Override
    public KvStoreFrontend create(KvStoreFrontend model, IncomingApiFields<KvStoreFrontend> incomingApiFields,
                                  List<DefectInfo<Defect>> parseDefectInfos) {
        if (Objects.isNull(model.getUserId())) {
            var userId = getUserId();
            model.setUserId(userId);
        }

        return super.create(model, incomingApiFields, parseDefectInfos);
    }

    @Override
    protected ActionsResult<?> saveInternal(
            KvStoreFrontend model,
            IncomingApiFields<KvStoreFrontend> updatedFields,
            boolean isDryRun
    ) {
        KvStoreFrontend prefetchedModel = findOne(model.getId(), Set.of(), !isDryRun);
        if (prefetchedModel == null) {
            throw new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__NOT_FOUND);
        }
        return kvStoreFrontendService.update(
                List.of(model),
                List.of(prefetchedModel),
                getUpdateRequestAuthLifecycle()
        );
    }

    @Override
    protected ActionsResult<?> createInternal(KvStoreFrontend model,
                                              IncomingApiFields<KvStoreFrontend> incomingApiFields) {
        return kvStoreFrontendService.create(List.of(model), incomingApiFields);
    }

    @Override
    protected Optional<KvStoreFrontend> tryFindAlreadyExisting(KvStoreFrontend model) {
        return kvStoreFrontendService.findAll(QueryOpts.forClass(KvStoreFrontend.class)
                .withFilter(and(CoreFilterNode.eq(KvStoreFrontendFilters.USER_ID, model.getUserId()),
                        CoreFilterNode.eq(KvStoreFrontendFilters.KEY, model.getKey())))
        ).stream().collect(MoreCollectors.onlyOne());
    }

    @Override
    public KvStoreFrontend save(KvStoreFrontend model, IncomingApiFields<KvStoreFrontend> updatedFields,
                                List<DefectInfo<Defect>> parseDefectInfos) {
        var currentUserId = getUserId();

        if (Objects.isNull(model.getUserId())) {
            model.setUserId(currentUserId);
        }

        return super.save(model, updatedFields, parseDefectInfos);
    }

    @Override
    public boolean apiCanAdd() {
        return false;
    }

    @Nullable
    @Override
    protected String postRightName() {
        return null;
    }

    @Override
    public String coreIdToApiId(Long id) {
        return String.valueOf(id);
    }

    @Override
    public Long apiIdToCoreId(String id) {
        return Long.valueOf(id);
    }

}
