package ru.yandex.partner.jsonapi.models.kvstorefrontend

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.partner.core.entity.kvstorefrontend.model.KvStoreFrontend
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesServiceImpl
import ru.yandex.partner.jsonapi.crnk.kvstorefrontend.authorization.KvStoreFrontendAuthorizationPolicy
import ru.yandex.partner.jsonapi.models.ApiModelPart
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite

@Configuration
class ApiKvStoreFrontendConfiguration {
    @Bean
    fun apiKvFrontendModel(apiKvFrontendModelMetaData: ApiKvFrontendModelMetaData,
                           policy: KvStoreFrontendAuthorizationPolicy): ApiKvFrontendModel {
        val modelPart: ApiModelPart<KvStoreFrontend> = ApiFieldKvStoreFrontendModelPart()

        val apiFields = modelPart.fields
        val apiFieldsAvailableRules = ApiFieldsAccessRulesServiceImpl(
            ApiFieldsAccessRules.build(
                apiFields.map { it.availableFunction },
                CommonFunctionComposite()))
        val apiFieldsEditableRules = ApiFieldsAccessRulesServiceImpl(
            ApiFieldsAccessRules.build(
                apiFields.mapNotNull { it.editableFunction },
                CommonFunctionComposite()))

        return ApiKvFrontendModel(apiKvFrontendModelMetaData, listOf(modelPart), policy,
            apiFieldsAvailableRules, apiFieldsEditableRules)
    }
}
