package ru.yandex.partner.jsonapi.models.page;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.page.model.PageWithMultistate;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.models.AbstractApiService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.actions.ActionService;
import ru.yandex.partner.libs.i18n.TranslatableError;

@ParametersAreNonnullByDefault
public class ApiPageService<M extends PageWithMultistate> extends AbstractApiService<M> {

    @SuppressWarnings("checkstyle:parameternumber")
    public ApiPageService(
            DefectPresentationRegistry<TranslatableError> defectRegistry,
            ModelQueryService<? super M> modelService,
            RequestAuthorizationService requestAuthorizationService,
            ActionsAuthorizationService<M> actionsAuthorizationService,
            ApiFieldsService<M> apiFieldsService,
            ApiModel<M> apiModel,
            ActionService<M> actionService,
            ActionPerformer actionPerformer
    ) {
        super(
                defectRegistry,
                modelService,
                requestAuthorizationService,
                actionsAuthorizationService,
                apiFieldsService,
                apiModel,
                actionService,
                actionPerformer
        );
    }

    @Override
    public String coreIdToApiId(Long id) {
        return String.valueOf(id);
    }

    @Override
    public Long apiIdToCoreId(String id) {
        return Long.valueOf(id);
    }
}
