package ru.yandex.partner.jsonapi.models.page.external

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry
import ru.yandex.partner.core.action.ActionPerformer
import ru.yandex.partner.core.entity.page.model.ContextPage
import ru.yandex.partner.core.entity.page.service.PageService
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.Builder
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.build
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesServiceImpl
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService
import ru.yandex.partner.jsonapi.crnk.fields.EditableData
import ru.yandex.partner.jsonapi.crnk.page.authorization.PageAuthorizationPolicy
import ru.yandex.partner.jsonapi.models.ApiModelMetaData
import ru.yandex.partner.jsonapi.models.ApiModelPart
import ru.yandex.partner.jsonapi.models.ApiModel
import ru.yandex.partner.jsonapi.models.ApiService
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite
import ru.yandex.partner.jsonapi.models.actions.ActionService
import ru.yandex.partner.jsonapi.models.page.ApiPageService
import ru.yandex.partner.jsonapi.models.page.external.parts.ApiContextOnSiteCampaignPart
import ru.yandex.partner.libs.i18n.TranslatableError
import java.util.function.Consumer

@Configuration
class ApiPageConfiguration {
    @Bean
    fun contextPageApiModel(
        apiModelMetaData: ApiModelMetaData<ContextPage>,
        pageAuthorizationPolicy: PageAuthorizationPolicy?,
        apiContextOnSiteCampaignPart: ApiContextOnSiteCampaignPart
    ): ContextPageApiModel {

        val apiFieldsAvailableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<ContextPage>>>(),
                CommonFunctionComposite()
            )
        )
        val apiFieldsEditableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<EditableData<ContextPage>>>>(),
                CommonFunctionComposite()
            )
        )
        val modelParts = mutableListOf(apiContextOnSiteCampaignPart)

        return ContextPageApiModel(
            apiModelMetaData,
            modelParts as List<ApiModelPart<ContextPage>>?,
            pageAuthorizationPolicy,
            apiFieldsAvailableRules, apiFieldsEditableRules
        )
    }

    @Bean
    fun apiContextPageService(
        defectRegistry: DefectPresentationRegistry<TranslatableError>,
        modelService: PageService,
        requestAuthorizationService: RequestAuthorizationService,
        actionsAuthorizationService: ActionsAuthorizationService<ContextPage>,
        apiFieldsService: ApiFieldsService<ContextPage>,
        apiModel: ApiModel<ContextPage>,
        actionService: ActionService<ContextPage>,
        actionPerformer: ActionPerformer
    ) : ApiService<ContextPage> {
        return ApiPageService(
            defectRegistry,
            modelService,
            requestAuthorizationService,
            actionsAuthorizationService,
            apiFieldsService,
            apiModel,
            actionService,
            actionPerformer
        );
    }
}
