package ru.yandex.partner.jsonapi.models.page.external;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class ContextPageApiModel extends AbstractApiModel<ContextPage> {

    private final Policy<ContextPage> pageAuthorizationPolicy;

    public ContextPageApiModel(ApiModelMetaData<ContextPage> apiModelMetaData,
                               List<ApiModelPart<ContextPage>> parts,
                               Policy<ContextPage> pageAuthorizationPolicy,
                               ApiFieldsAccessRulesService<ContextPage> apiFieldsAvailableRules,
                               ApiFieldsAccessRulesService<EditableData<ContextPage>> apiFieldsEditableRules) {
        super(apiModelMetaData, parts, apiFieldsAvailableRules, apiFieldsEditableRules);
        this.pageAuthorizationPolicy = pageAuthorizationPolicy;
    }

    @Override
    public ContextPage createNewInstance() {
        return new ContextPage();
    }

    @Override
    public Policy<ContextPage> getPolicy() {
        return pageAuthorizationPolicy;
    }

    @Override
    public MetaFilter<? super ContextPage, Long> getIdFilter() {
        return PageFilters.PAGE_ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Collections.emptyMap();
    }
}
