package ru.yandex.partner.jsonapi.models.page.external.parts;

import java.util.List;
import java.util.Map;

import io.crnk.core.engine.information.resource.ResourceFieldType;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkModelFilters;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

@Component
public class ApiContextOnSiteCampaignPart implements ApiModelPart<ContextPage> {
    private final PageCrnkModelFilters pageCrnkModelFilters;

    public ApiContextOnSiteCampaignPart(PageCrnkModelFilters pageCrnkModelFilters) {
        this.pageCrnkModelFilters = pageCrnkModelFilters;
    }

    @Override
    public List<ApiField<ContextPage>> getFields() {
        return List.of(
                ApiField
                        .<ContextPage, Long>convertibleApiField(Long.class, ContextPage.ID)
                        .withResourceFieldType(ResourceFieldType.ID)
                        .build(PageCrnkJsonFieldAliases.ID)
        );
    }

    @Override
    public Map<String, CrnkFilter<ContextPage, ?>> getFilters() {
        return pageCrnkModelFilters.getFilters();
    }
}
