package ru.yandex.partner.jsonapi.models.page.internal

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry
import ru.yandex.partner.core.action.ActionPerformer
import ru.yandex.partner.core.entity.page.model.ContextPage
import ru.yandex.partner.core.entity.page.model.InternalContextPage
import ru.yandex.partner.core.entity.page.service.PageService
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.Builder
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.build
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesServiceImpl
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService
import ru.yandex.partner.jsonapi.crnk.fields.EditableData
import ru.yandex.partner.jsonapi.crnk.page.authorization.InternalPageAuthorizationPolicy
import ru.yandex.partner.jsonapi.models.*
import ru.yandex.partner.jsonapi.models.actions.ActionService
import ru.yandex.partner.jsonapi.models.page.ApiPageService
import ru.yandex.partner.jsonapi.models.page.external.parts.ApiContextOnSiteCampaignPart
import ru.yandex.partner.jsonapi.models.page.internal.parts.ApiInternalContextOnSiteCampaignPart
import ru.yandex.partner.libs.i18n.TranslatableError
import java.util.function.Consumer

@Configuration
class ApiInternalPageConfiguration {
    @Bean
    fun internalContextPageApiModel(
        apiModelMetaData: ApiModelMetaData<InternalContextPage>,
        internalPageAuthorizationPolicy: InternalPageAuthorizationPolicy?,
        apiInternalContextOnSiteCampaignPart: ApiInternalContextOnSiteCampaignPart
    ): InternalContextPageApiModel {

        val apiFieldsAvailableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<InternalContextPage>>>(),
                CommonFunctionComposite()
            )
        )
        val apiFieldsEditableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<EditableData<InternalContextPage>>>>(),
                CommonFunctionComposite()
            )
        )
        val modelPart = mutableListOf(apiInternalContextOnSiteCampaignPart)

        return InternalContextPageApiModel(
            apiModelMetaData,
            modelPart as List<ApiModelPart<InternalContextPage>>?,
            internalPageAuthorizationPolicy,
            apiFieldsAvailableRules, apiFieldsEditableRules
        )
    }

    @Bean
    fun apiInternalContextPageService(
        defectRegistry: DefectPresentationRegistry<TranslatableError>,
        modelService: PageService,
        requestAuthorizationService: RequestAuthorizationService,
        actionsAuthorizationService: ActionsAuthorizationService<InternalContextPage>,
        apiFieldsService: ApiFieldsService<InternalContextPage>,
        apiModel: ApiModel<InternalContextPage>,
        actionService: ActionService<InternalContextPage>,
        actionPerformer: ActionPerformer
    ) : ApiService<InternalContextPage> {
        return ApiPageService(
            defectRegistry,
            modelService,
            requestAuthorizationService,
            actionsAuthorizationService,
            apiFieldsService,
            apiModel,
            actionService,
            actionPerformer
        );
    }
}
