package ru.yandex.partner.jsonapi.models.page.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class InternalContextPageApiModel extends AbstractApiModel<InternalContextPage> {

    private final Policy<InternalContextPage> pageAuthorizationPolicy;

    public InternalContextPageApiModel(
            ApiModelMetaData<InternalContextPage> apiModelMetaData,
            List<ApiModelPart<InternalContextPage>> parts,
            Policy<InternalContextPage> pageAuthorizationPolicy,
            ApiFieldsAccessRulesService<InternalContextPage> apiFieldsAvailableRules,
            ApiFieldsAccessRulesService<EditableData<InternalContextPage>> apiFieldsEditableRules) {

        super(apiModelMetaData, parts, apiFieldsAvailableRules, apiFieldsEditableRules);
        this.pageAuthorizationPolicy = pageAuthorizationPolicy;
    }

    @Override
    public InternalContextPage createNewInstance() {
        return new InternalContextPage();
    }

    @Override
    public Policy<InternalContextPage> getPolicy() {
        return pageAuthorizationPolicy;
    }

    @Override
    public MetaFilter<? super InternalContextPage, Long> getIdFilter() {
        return PageFilters.PAGE_ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Collections.emptyMap();
    }
}
