package ru.yandex.partner.jsonapi.models.page.internal.parts;

import java.util.List;
import java.util.Map;

import io.crnk.core.engine.information.resource.ResourceFieldType;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.page.model.InternalContextPage;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.page.InternalPageCrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

@Component
public class ApiInternalContextOnSiteCampaignPart implements ApiModelPart<InternalContextPage> {
    private final InternalPageCrnkModelFilters internalPageCrnkModelFilters;

    public ApiInternalContextOnSiteCampaignPart(InternalPageCrnkModelFilters internalPageCrnkModelFilters) {
        this.internalPageCrnkModelFilters = internalPageCrnkModelFilters;
    }

    @Override
    public List<ApiField<InternalContextPage>> getFields() {
        return List.of(
                ApiField
                        .<InternalContextPage, Long>convertibleApiField(Long.class, InternalContextPage.ID)
                        .withResourceFieldType(ResourceFieldType.ID)
                        .build(PageCrnkJsonFieldAliases.ID)
        );
    }

    @Override
    public Map<String, CrnkFilter<InternalContextPage, ?>> getFilters() {
        return internalPageCrnkModelFilters.getFilters();
    }
}
