package ru.yandex.partner.jsonapi.models.page.mobile.external

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry
import ru.yandex.partner.core.action.ActionPerformer
import ru.yandex.partner.core.entity.ModelQueryService
import ru.yandex.partner.core.entity.page.model.BasePage
import ru.yandex.partner.core.entity.page.model.MobileAppSettings
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.Builder
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.build
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesServiceImpl
import ru.yandex.partner.jsonapi.crnk.fields.EditableData
import ru.yandex.partner.jsonapi.crnk.page.MobileAppSettingsApiFieldsService
import ru.yandex.partner.jsonapi.crnk.page.authorization.MobileAppSettingsAuthorizationPolicy
import ru.yandex.partner.jsonapi.models.ApiModel
import ru.yandex.partner.jsonapi.models.ApiModelPart
import ru.yandex.partner.jsonapi.models.ApiService
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite
import ru.yandex.partner.jsonapi.models.page.ApiPageService
import ru.yandex.partner.jsonapi.models.page.mobile.external.actions.MobileAppSettingsActionService
import ru.yandex.partner.jsonapi.models.page.mobile.external.parts.ApiMobileAppSettingsPart
import ru.yandex.partner.libs.i18n.TranslatableError
import java.util.function.Consumer

@Configuration
class ApiMobileAppSettingsPageConfiguration {
    @Bean
    fun mobileAppSettingsPageApiModel(
        apiModelMetaData: ApiMobileAppSettingsMetaData,
        pageAuthorizationPolicy: MobileAppSettingsAuthorizationPolicy,
        apiMobileAppSettingsPart: ApiMobileAppSettingsPart
    ): MobileAppSettingsPageApiModel {

        val apiFieldsAvailableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<MobileAppSettings>>>(),
                CommonFunctionComposite()
            )
        )
        val apiFieldsEditableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<EditableData<MobileAppSettings>>>>(),
                CommonFunctionComposite()
            )
        )
        val modelPart = mutableListOf(apiMobileAppSettingsPart)

        return MobileAppSettingsPageApiModel(
            apiModelMetaData,
            modelPart as List<ApiModelPart<MobileAppSettings>>?,
            pageAuthorizationPolicy,
            apiFieldsAvailableRules, apiFieldsEditableRules
        )
    }

    @Bean
    fun mobileAppSettingsPageApiService(
        defectRegistry: DefectPresentationRegistry<TranslatableError>,
        modelService: ModelQueryService<BasePage>,
        requestAuthorizationService: RequestAuthorizationService,
        actionsAuthorizationService: ActionsAuthorizationService<MobileAppSettings>,
        apiFieldsService: MobileAppSettingsApiFieldsService,
        apiModel: ApiModel<MobileAppSettings>,
        actionService: MobileAppSettingsActionService,
        actionPerformer: ActionPerformer
    ): ApiService<MobileAppSettings> {
        return ApiPageService(
            defectRegistry,
            modelService,
            requestAuthorizationService,
            actionsAuthorizationService,
            apiFieldsService,
            apiModel,
            actionService,
            actionPerformer
        )
    }
}
