package ru.yandex.partner.jsonapi.models.page.mobile.external;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class MobileAppSettingsPageApiModel extends AbstractApiModel<MobileAppSettings> {

    private final Policy<MobileAppSettings> pageAuthorizationPolicy;

    public MobileAppSettingsPageApiModel(ApiModelMetaData<MobileAppSettings> apiModelMetaData,
                                         List<ApiModelPart<MobileAppSettings>> parts,
                                         Policy<MobileAppSettings> pageAuthorizationPolicy,
                                         ApiFieldsAccessRulesService<MobileAppSettings> apiFieldsAvailableRules,
                                         ApiFieldsAccessRulesService<EditableData<MobileAppSettings>>
                                                 apiFieldsEditableRules) {
        super(apiModelMetaData, parts, apiFieldsAvailableRules, apiFieldsEditableRules);
        this.pageAuthorizationPolicy = pageAuthorizationPolicy;
    }

    @Override
    public MobileAppSettings createNewInstance() {
        return new MobileAppSettings();
    }

    @Override
    public Policy<MobileAppSettings> getPolicy() {
        return pageAuthorizationPolicy;
    }

    @Override
    public MetaFilter<? super MobileAppSettings, Long> getIdFilter() {
        return PageFilters.PAGE_ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Collections.emptyMap();
    }
}
