package ru.yandex.partner.jsonapi.models.page.mobile.external.parts;

import java.util.List;
import java.util.Map;

import io.crnk.core.engine.information.resource.ResourceFieldType;
import org.springframework.stereotype.Component;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.page.MobileAppCrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

@Component
public class ApiMobileAppSettingsPart implements ApiModelPart<MobileAppSettings> {
    private final MobileAppCrnkModelFilters mobileAppCrnkModelFilters;

    public ApiMobileAppSettingsPart(MobileAppCrnkModelFilters mobileAppCrnkModelFilters) {
        this.mobileAppCrnkModelFilters = mobileAppCrnkModelFilters;
    }

    @Override
    public List<ApiField<MobileAppSettings>> getFields() {
        return List.of(
                ApiField
                        .<MobileAppSettings, Long>convertibleApiField(Long.class, MobileAppSettings.ID)
                        .withResourceFieldType(ResourceFieldType.ID)
                        .build(PageCrnkJsonFieldAliases.ID),
                ApiField
                        .<MobileAppSettings, Long>convertibleApiField(Long.class, MobileAppSettings.PAGE_ID)
                        .build(PageCrnkJsonFieldAliases.PAGE_ID)
        );
    }

    @Override
    public Map<String, CrnkFilter<MobileAppSettings, ?>> getFilters() {
        return mobileAppCrnkModelFilters.getFilters();
    }
}
