package ru.yandex.partner.jsonapi.models.page.mobile.internal

import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.direct.validation.presentation.DefectPresentationRegistry
import ru.yandex.partner.core.action.ActionPerformer
import ru.yandex.partner.core.entity.ModelQueryService
import ru.yandex.partner.core.entity.page.model.BasePage
import ru.yandex.partner.core.entity.page.model.InternalMobileApp
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.Builder
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.build
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesServiceImpl
import ru.yandex.partner.jsonapi.crnk.fields.EditableData
import ru.yandex.partner.jsonapi.crnk.page.InternalMobileAppApiFieldsService
import ru.yandex.partner.jsonapi.crnk.page.authorization.InternalMobileAppAuthorizationPolicy
import ru.yandex.partner.jsonapi.models.ApiModel
import ru.yandex.partner.jsonapi.models.ApiModelPart
import ru.yandex.partner.jsonapi.models.ApiService
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite
import ru.yandex.partner.jsonapi.models.page.ApiPageService
import ru.yandex.partner.jsonapi.models.page.mobile.internal.actions.InternalMobileAppActionService
import ru.yandex.partner.jsonapi.models.page.mobile.internal.parts.ApiInternalMobileAppPart
import ru.yandex.partner.libs.i18n.TranslatableError
import java.util.function.Consumer

@Configuration
class ApiInternalMobileAppPageConfiguration {
    @Bean
    fun internalMobileAppPageApiModel(
        apiModelMetaData: ApiInternalMobileAppMetaData,
        pageAuthorizationPolicy: InternalMobileAppAuthorizationPolicy,
        apiInternalMobileAppPart: ApiInternalMobileAppPart
    ): InternalMobileAppPageApiModel {

        val apiFieldsAvailableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<InternalMobileApp>>>(),
                CommonFunctionComposite()
            )
        )
        val apiFieldsEditableRules = ApiFieldsAccessRulesServiceImpl(
            build(
                mutableListOf<Consumer<Builder<EditableData<InternalMobileApp>>>>(),
                CommonFunctionComposite()
            )
        )
        val modelPart = mutableListOf(apiInternalMobileAppPart)

        return InternalMobileAppPageApiModel(
            apiModelMetaData,
            modelPart as List<ApiModelPart<InternalMobileApp>>?,
            pageAuthorizationPolicy,
            apiFieldsAvailableRules, apiFieldsEditableRules
        )
    }

    @Bean
    fun internalMobileAppPageApiService(
        defectRegistry: DefectPresentationRegistry<TranslatableError>,
        modelService: ModelQueryService<BasePage>,
        requestAuthorizationService: RequestAuthorizationService,
        actionsAuthorizationService: ActionsAuthorizationService<InternalMobileApp>,
        apiFieldsService: InternalMobileAppApiFieldsService,
        apiModel: ApiModel<InternalMobileApp>,
        actionService: InternalMobileAppActionService,
        actionPerformer: ActionPerformer
    ): ApiService<InternalMobileApp> {
        return ApiPageService(
            defectRegistry,
            modelService,
            requestAuthorizationService,
            actionsAuthorizationService,
            apiFieldsService,
            apiModel,
            actionService,
            actionPerformer
        )
    }
}
