package ru.yandex.partner.jsonapi.models.page.mobile.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelMetaData;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

public class InternalMobileAppPageApiModel extends AbstractApiModel<InternalMobileApp> {

    private final Policy<InternalMobileApp> pageAuthorizationPolicy;

    public InternalMobileAppPageApiModel(ApiModelMetaData<InternalMobileApp> apiModelMetaData,
                                         List<ApiModelPart<InternalMobileApp>> parts,
                                         Policy<InternalMobileApp> pageAuthorizationPolicy,
                                         ApiFieldsAccessRulesService<InternalMobileApp> apiFieldsAvailableRules,
                                         ApiFieldsAccessRulesService<EditableData<InternalMobileApp>>
                                                 apiFieldsEditableRules) {
        super(apiModelMetaData, parts, apiFieldsAvailableRules, apiFieldsEditableRules);
        this.pageAuthorizationPolicy = pageAuthorizationPolicy;
    }

    @Override
    public InternalMobileApp createNewInstance() {
        return new InternalMobileApp();
    }

    @Override
    public Policy<InternalMobileApp> getPolicy() {
        return pageAuthorizationPolicy;
    }

    @Override
    public MetaFilter<? super InternalMobileApp, Long> getIdFilter() {
        return PageFilters.PAGE_ID;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Collections.emptyMap();
    }
}
