package ru.yandex.partner.jsonapi.models.page.mobile.internal.parts;

import java.util.List;
import java.util.Map;

import io.crnk.core.engine.information.resource.ResourceFieldType;
import org.springframework.stereotype.Component;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.page.InternalMobileAppCrnkModelFilters;
import ru.yandex.partner.jsonapi.crnk.page.PageCrnkJsonFieldAliases;
import ru.yandex.partner.jsonapi.models.ApiModelPart;

@Component
public class ApiInternalMobileAppPart implements ApiModelPart<InternalMobileApp> {
    private final InternalMobileAppCrnkModelFilters mobileAppCrnkModelFilters;

    public ApiInternalMobileAppPart(InternalMobileAppCrnkModelFilters mobileAppCrnkModelFilters) {
        this.mobileAppCrnkModelFilters = mobileAppCrnkModelFilters;
    }

    @Override
    public List<ApiField<InternalMobileApp>> getFields() {
        return List.of(
                ApiField
                        .<InternalMobileApp, Long>convertibleApiField(Long.class, InternalMobileApp.ID)
                        .withResourceFieldType(ResourceFieldType.ID)
                        .build(PageCrnkJsonFieldAliases.ID),
                ApiField
                        .<InternalMobileApp, Long>convertibleApiField(Long.class, InternalMobileApp.PAGE_ID)
                        .build(PageCrnkJsonFieldAliases.PAGE_ID)
        );
    }

    @Override
    public Map<String, CrnkFilter<InternalMobileApp, ?>> getFilters() {
        return mobileAppCrnkModelFilters.getFilters();
    }
}
