package ru.yandex.partner.jsonapi.models.relationships;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import io.crnk.core.engine.document.Relationship;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.jsonapi.models.ApiResourceType;

public interface ApiRelationship<M extends ModelWithId> {
    /**
     * @return true - связь один-к-одному, false - связь один-ко-многим
     */
    boolean isOne();

    /**
     * @return Список json-полей, которые нужны для вычисления ID relationship модели
     */
    List<String> getFieldsForCalcId();

    /**
     * @return тип ресурса
     * У нас это строка которая следует после /v1/{resourceType}/{ID}
     */
    ApiResourceType getApiResourceType();

    /**
     * @return название json-поля
     */
    default String getField() {
        return getApiResourceType().getResourceType();
    }

    /**
     * @param model модель к которой относится этот relationship с полями {@link #getFieldsForCalcId()}
     * @return Relationship с заполнеными id и resourceType
     */
    Relationship getRelationship(M model);

    /**
     * можно вызывать когда {@link #isOne()} == true
     *
     * @param sourceIds идентификаторы исходной модели
     * @return мапа идентификаторов исходной модели на идентификаторы relationship модели
     */
    // TODO подумать как избавиться от лишнего запроса, например возвращать фильтры
    Map<String, String> getSourceIdToTargetIdMap(Collection<String> sourceIds);

    /**
     * можно вызывать когда {@link #isOne()} == false
     *
     * @param sourceIds идентификаторы исходной модели
     * @return мапа идентификаторов исходной модели на список идентификаторов relationship модели
     */
    // TODO подумать как избавиться от лишнего запроса, например возвращать фильтры
    Map<String, List<String>> getSourceIdToTargetIdsMap(Collection<String> sourceIds);
}
