package ru.yandex.partner.jsonapi.models.relationships;

import java.util.Collection;
import java.util.Map;

import ru.yandex.direct.model.ModelWithId;

public interface ManyApiRelationship<M extends ModelWithId> extends ApiRelationship<M> {

    @Override
    default boolean isOne() {
        return false;
    }

    @Override
    default Map<String, String> getSourceIdToTargetIdMap(Collection<String> sourceIds) {
        throw new UnsupportedOperationException("This is a one-to-many relationship");
    }
}
