package ru.yandex.partner.jsonapi.models.relationships;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import ru.yandex.direct.model.ModelWithId;

public interface OneApiRelationship<M extends ModelWithId> extends ApiRelationship<M> {

    @Override
    default boolean isOne() {
        return true;
    }

    @Override
    default Map<String, List<String>> getSourceIdToTargetIdsMap(Collection<String> sourceIds) {
        throw new UnsupportedOperationException("This is a one-to-one relationship");
    }
}
