package ru.yandex.partner.jsonapi.models.relationships;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.LinksRepository;
import io.crnk.core.repository.ManyRelationshipRepository;
import io.crnk.core.repository.OneRelationshipRepository;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.list.ResourceList;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.partner.jsonapi.crnk.DynamicResourceRepository;
import ru.yandex.partner.jsonapi.service.CrnkAdditionalDataService;

public class RelationshipRepositoryImpl<M extends ModelWithId>
        implements
        OneRelationshipRepository<Resource, String, Resource, String>,
        ManyRelationshipRepository<Resource, String, Resource, String>,
        LinksRepository<Resource> {


    private final ApiRelationship<M> apiRelationship;
    private final DynamicResourceRepository<?> dynamicResourceRepository;

    public RelationshipRepositoryImpl(ApiRelationship<M> apiRelationship,
                                      DynamicResourceRepository<?> dynamicResourceRepository) {
        this.apiRelationship = apiRelationship;
        this.dynamicResourceRepository = dynamicResourceRepository;
    }

    @Override
    public RelationshipMatcher getMatcher() {
        RelationshipMatcher matcher = new RelationshipMatcher();
        matcher.rule().source(Resource.class).target(Resource.class).add();
        return matcher;
    }

    @Override
    public Map<String, ResourceList<Resource>> findManyRelations(Collection<String> sourceIds, String fieldName,
                                                                 QuerySpec querySpec) {
        return apiRelationship.getSourceIdToTargetIdsMap(sourceIds).entrySet()
                .stream()
                .map(id -> Map.entry(id.getKey(), dynamicResourceRepository.findAll(id.getValue(), querySpec)))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, Resource> findOneRelations(Collection<String> sourceIds, String fieldName, QuerySpec querySpec) {
        return apiRelationship.getSourceIdToTargetIdMap(sourceIds).entrySet().stream()
                .map(id -> Map.entry(id.getKey(), dynamicResourceRepository.findOne(id.getValue(), querySpec)))
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void setRelations(Resource source, Collection<String> targetIds, String fieldName) {
    }

    @Override
    public void addRelations(Resource source, Collection<String> targetIds, String fieldName) {
    }

    @Override
    public void removeRelations(Resource source, Collection<String> targetIds, String fieldName) {
    }

    @Override
    public void setRelation(Resource source, String targetId, String fieldName) {
    }


    @Override
    public LinksInformation getLinksInformation(Collection<Resource> resources, QuerySpec querySpec,
                                                LinksInformation current) {
        HttpRequestContext httpRequestContext = dynamicResourceRepository
                .getHttpRequestContextProvider()
                .getRequestContextResult()
                .get();

        CrnkAdditionalDataService crnkAdditionalDataService = dynamicResourceRepository.getCrnkAdditionalDataService();
        return crnkAdditionalDataService.getLinksForRelationship(httpRequestContext);
    }
}
